import { ApiSecurity, ApiUrl, AppDetails } from '../../shared';
import { UserReferral } from './types';
export * as ReferralTypes from './types';
export declare class Referrals {
    private readonly client;
    private readonly appDetails;
    private readonly apiSecurity;
    static client(apiUrl: ApiUrl, appDetails: AppDetails, apiSecurity: ApiSecurity): Referrals;
    private constructor();
    /**
     * Returns a list of referrals of this user
     */
    getReferrals(): Promise<UserReferral[]>;
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    private headers;
}
