/**
 * Converts a base64 url safe string to uuid v4
 *
 * @example in: `8yqR2seZThOqF4xNngMjyQ` out: `f32a91da-c799-4e13-aa17-8c4d9e0323c9`
 */
declare function base64UrlSafetoUUID(base64UrlSafe: string): string;
declare const _default: {
    toBase64UrlSafe: (base64: string) => string;
    fromBase64UrlSafe: (urlSafe: string) => string;
    generateRandomStringUrlSafe: (size: number) => string;
    base64UrlSafetoUUID: typeof base64UrlSafetoUUID;
    decodeV4Uuid: (value: string) => string;
    encodeV4Uuid: (v4Uuid: string) => string;
};
export default _default;
