"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = renameIfNeeded;
/**
 * Checks if a rename is needed and returns the new filename.
 * For example, if a file test.txt already exists, the new
 * filename will be test (1).txt.
 *
 * @param items Existing items in a folder
 * @param filename Filename of the new item
 * @param type Type of the new item
 * @returns
 * - Whether it already exists
 * - The number between parethensis. 0 if it already exists.
 * - The new filename. It can be the same as the input
 *   if it doesn't exist already.
 */
function renameIfNeeded(items, filename, type) {
    var FILENAME_INCREMENT_REGEX = /( \([0-9]+\))$/i;
    var INCREMENT_INDEX_REGEX = /\(([^)]+)\)/;
    var cleanFilename = filename.replace(FILENAME_INCREMENT_REGEX, '');
    var infoFilenames = items
        .map(function (item) {
        var _a, _b, _c;
        var cleanName = item.name.replace(FILENAME_INCREMENT_REGEX, '');
        var incrementString = (_c = (_b = (_a = item.name.match(FILENAME_INCREMENT_REGEX)) === null || _a === void 0 ? void 0 : _a.pop()) === null || _b === void 0 ? void 0 : _b.match(INCREMENT_INDEX_REGEX)) === null || _c === void 0 ? void 0 : _c.pop();
        var incrementIndex = parseInt(incrementString || '0');
        return {
            name: item.name,
            cleanName: cleanName,
            type: item.type,
            incrementIndex: incrementIndex,
        };
    })
        .filter(function (item) {
        var _a, _b, _c;
        return item.cleanName.toLowerCase() === cleanFilename.toLowerCase()
            && ((_b = (_a = item.type) === null || _a === void 0 ? void 0 : _a.toLowerCase()) !== null && _b !== void 0 ? _b : '') === ((_c = type === null || type === void 0 ? void 0 : type.toLowerCase()) !== null && _c !== void 0 ? _c : '');
    })
        .sort(function (a, b) { return b.incrementIndex - a.incrementIndex; });
    var filenameExists = !!infoFilenames.length;
    if (filenameExists) {
        var index = infoFilenames[0].incrementIndex + 1;
        return [true, index, getNextNewName(cleanFilename, index)];
    }
    else {
        return [false, 0, filename];
    }
}
function getNextNewName(filename, i) {
    return "".concat(filename, " (").concat(i, ")");
}
