"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = getFilenameAndExt;
/**
 * Separates entire filename in filename and extension
 *
 * @param entireFilename Filename + extension
 * @returns Filename and extension splitted
 */
function getFilenameAndExt(entireFilename) {
    // based on path.parse native nodejs function
    var re = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^/]+?|)(\.[^./]*|))(?:[/]*)$/;
    var fileInfo = re.exec(entireFilename);
    if (!fileInfo) {
        return { filename: '', extension: '' };
    }
    var extensionWithDot = fileInfo[4];
    var filename = fileInfo[3].substring(0, fileInfo[3].length - extensionWithDot.length);
    var extension = extensionWithDot.split('.')[1];
    return { filename: filename, extension: extension };
}
