"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = testPasswordStrength;
/**
 *
 * @param password
 * @param userAccountName
 */
function testPasswordStrength(password, userAccountName) {
    if (password.length < 8) {
        return { valid: false, reason: 'NOT_LONG_ENOUGH' };
    }
    var containsUppercaseChars = /^.*[A-Z].*$/.test(password);
    var containsLowercaseChars = /^.*[a-z].*$/.test(password);
    var containsDigits = /^.*\d.*$/.test(password);
    var containsNonAlphanumeric = /^.*[^\w_].*$/.test(password);
    var notLooksLikeHisAccountName = !passwordLooksLikeAccountName(password, userAccountName);
    var categories = [
        containsUppercaseChars,
        containsLowercaseChars,
        containsDigits,
        containsNonAlphanumeric,
        notLooksLikeHisAccountName,
    ];
    var positiveCategories = categories.reduce(function (prev, current) { return prev + (current ? 1 : 0); }, 0);
    if (positiveCategories < 3) {
        return { valid: false, reason: 'NOT_COMPLEX_ENOUGH' };
    }
    else if (positiveCategories === 3) {
        return { valid: true, strength: 'medium' };
    }
    else {
        return { valid: true, strength: 'hard' };
    }
}
function passwordLooksLikeAccountName(password, userAccountName) {
    if (userAccountName.length < 3)
        return false;
    var slices = [];
    for (var i = 0; i < userAccountName.length; i++) {
        for (var j = 3; j <= userAccountName.length; j++) {
            slices.push(userAccountName.slice(i, j).toLowerCase());
        }
    }
    return slices.some(function (slice) { return password.toLowerCase().indexOf(slice) !== -1; });
}
