"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.emailRegexPattern = void 0;
exports.default = isValidEmail;
// RFC 5322 Official Standard
exports.emailRegexPattern = 
// eslint-disable-next-line no-control-regex, max-len
/^((?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*"))@((?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\]))$/;
/**
 * @param email An email to check
 * @returns Whether is or not valid
 */
function isValidEmail(email) {
    return !!email.toLowerCase().match(exports.emailRegexPattern);
}
