"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = encrypt;
var crypto_1 = __importDefault(require("crypto"));
/**
 *
 * @param text Text to encrypt
 * @param password
 * @param aesInit Object that contains IV + Salt. If its null, random bytes will be used.
 * @param hops
 * @returns Encrypted text
 */
function encrypt(text, password, aesInit, hops) {
    if (aesInit === void 0) { aesInit = null; }
    if (hops === void 0) { hops = 2145; }
    // random initialization vector
    var iv = aesInit ? Buffer.from(aesInit.iv || '', 'hex') : crypto_1.default.randomBytes(16);
    // random salt
    var salt = aesInit ? Buffer.from(aesInit.salt || '', 'hex') : crypto_1.default.randomBytes(64);
    // derive encryption key: 32 byte key length
    // in assumption the masterkey is a cryptographic and NOT a password there is no need for
    // a large number of iterations. It may can replaced by HKDF
    // the value of 2145 is randomly chosen!
    var key = crypto_1.default.pbkdf2Sync(password, salt, hops, 32, 'sha512');
    // AES 256 GCM Mode
    var cipher = crypto_1.default.createCipheriv('aes-256-gcm', key, iv);
    // encrypt the given text
    var encrypted = Buffer.concat([cipher.update(text, 'utf8'), cipher.final()]);
    // extract the auth tag
    var tag = cipher.getAuthTag();
    // generate output
    return Buffer.concat([salt, iv, tag, encrypted]).toString('base64');
}
