"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = decrypt;
var crypto_1 = __importDefault(require("crypto"));
/**
 *
 * @param encdata Encrypted text
 * @param password
 * @param iterations
 * @returns Decrypted text
 */
function decrypt(encdata, password, iterations) {
    if (iterations === void 0) { iterations = 2145; }
    // base64 decoding
    var bData = Buffer.from(encdata, 'base64');
    // convert data to buffers
    var salt = bData.slice(0, 64);
    var iv = bData.slice(64, 80);
    var tag = bData.slice(80, 96);
    var text = bData.slice(96);
    if (salt.length === 0 || iv.length === 0 || tag.length === 0 || text.length === 0) {
        throw Error('Length 0, cannot decrypt');
    }
    // derive key using; 32 byte key length
    var key = crypto_1.default.pbkdf2Sync(password, salt, iterations, 32, 'sha512');
    // AES 256 GCM Mode
    var decipher = crypto_1.default.createDecipheriv('aes-256-gcm', key, iv);
    decipher.setAuthTag(tag);
    // encrypt the given text
    var decrypted = decipher.update(text, undefined, 'utf8') + decipher.final('utf8');
    return decrypted;
}
