"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var sinon_1 = __importDefault(require("sinon"));
var headers_1 = require("../shared/headers");
var client_1 = require("../shared/http/client");
var index_1 = require("./index");
var httpClient = client_1.HttpClient.create('');
describe('Workspaces service tests', function () {
    beforeEach(function () {
        sinon_1.default.stub(client_1.HttpClient, 'create').returns(httpClient);
    });
    afterEach(function () {
        sinon_1.default.restore();
    });
    describe('Workspaces methods', function () {
        var workspacesResponse = {
            availableWorkspaces: [
                {
                    workspaceUser: {
                        id: '1',
                        memberId: 'member1',
                        key: 'user_key_1',
                        workspaceId: 'workspace1',
                        spaceLimit: '10GB',
                        driveUsage: '2GB',
                        backupsUsage: '1GB',
                        deactivated: false,
                        createdAt: '2024-04-30T12:00:00Z',
                        updatedAt: '2024-04-30T12:00:00Z',
                        freeSpace: '0',
                        isManager: false,
                        isOwner: false,
                        rootFolderId: 'asflaksfoau0su0fewnlsd',
                        member: {
                            avatar: null,
                            backupsBucket: null,
                            bridgeUser: 'email@email.com',
                            credit: 0,
                            email: 'email@email.com',
                            errorLoginCount: 0,
                            id: 7,
                            isEmailActivitySended: true,
                            lastPasswordChangedAt: null,
                            lastResend: null,
                            lastname: 'Lastname',
                            name: 'Name',
                            referralCode: 'referralCode',
                            referrer: null,
                            registerCompleted: true,
                            rootFolderId: 2,
                            sharedWorkspace: true,
                            syncDate: null,
                            userId: 'asflaksfoau0su0fewnlsd',
                            username: 'email@email.com',
                            uuid: 'asflaksfoau0su0fewnlsd',
                            welcomePack: true,
                        },
                        usedSpace: '0',
                    },
                    workspace: {
                        id: 'workspace1',
                        ownerId: 'owner1',
                        address: '123 Main St',
                        name: 'Workspace 1',
                        description: 'Description for Workspace 1',
                        defaultTeamId: 'team1',
                        workspaceUserId: '1',
                        setupCompleted: true,
                        createdAt: '2024-04-30T12:00:00Z',
                        updatedAt: '2024-04-30T12:00:00Z',
                        avatar: null,
                        rootFolderId: 'asflaksfoau0su0fewnlsd',
                        phoneNumber: null,
                    },
                },
                {
                    workspaceUser: {
                        id: '2',
                        memberId: 'member2',
                        key: 'user_key_2',
                        workspaceId: 'workspace2',
                        spaceLimit: '15GB',
                        driveUsage: '5GB',
                        backupsUsage: '3GB',
                        deactivated: false,
                        createdAt: '2024-04-30T12:00:00Z',
                        updatedAt: '2024-04-30T12:00:00Z',
                        freeSpace: '0',
                        isManager: false,
                        isOwner: false,
                        rootFolderId: 'asflaksfoau0su0fewnlsd',
                        member: {
                            avatar: null,
                            backupsBucket: null,
                            bridgeUser: 'email@email.com',
                            credit: 0,
                            email: 'email@email.com',
                            errorLoginCount: 0,
                            id: 7,
                            isEmailActivitySended: true,
                            lastPasswordChangedAt: null,
                            lastResend: null,
                            lastname: 'Lastname',
                            name: 'Name',
                            referralCode: 'referralCode',
                            referrer: null,
                            registerCompleted: true,
                            rootFolderId: 2,
                            sharedWorkspace: true,
                            syncDate: null,
                            userId: 'asflaksfoau0su0fewnlsd',
                            username: 'email@email.com',
                            uuid: 'asflaksfoau0su0fewnlsd',
                            welcomePack: true,
                        },
                        usedSpace: '0',
                    },
                    workspace: {
                        id: 'workspace2',
                        ownerId: 'owner2',
                        address: '456 Elm St',
                        name: 'Workspace 2',
                        description: 'Description for Workspace 2',
                        defaultTeamId: 'team2',
                        workspaceUserId: '2',
                        setupCompleted: true,
                        createdAt: '2024-04-30T12:00:00Z',
                        updatedAt: '2024-04-30T12:00:00Z',
                        avatar: null,
                        rootFolderId: 'asflaksfoau0su0fewnlsd',
                        phoneNumber: null,
                    },
                },
            ],
            pendingWorkspaces: [],
        };
        describe('getWorkspaces', function () {
            it('should return the expected workspaces when getWorkspaces is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            sinon_1.default.stub(httpClient, 'get').resolves(workspacesResponse);
                            return [4 /*yield*/, client.getWorkspaces()];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(workspacesResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getPendingWorkspaces', function () {
            it('should return the pending workspaces when getPendingWorkspaces is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            sinon_1.default.stub(httpClient, 'get').resolves(workspacesResponse);
                            return [4 /*yield*/, client.getPendingWorkspaces()];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(workspacesResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('setupWorkspace', function () {
            it('should set up the workspace successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceData, workspaceSetupInfo, _a, client, headers, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            workspaceData = {
                                name: 'Workspace Name',
                                address: 'Workspace Address',
                                description: 'Workspace Description',
                                encryptedMnemonic: 'encryptedMnemonic',
                            };
                            workspaceSetupInfo = __assign({ workspaceId: 'workspaceId' }, workspaceData);
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.setupWorkspace(workspaceSetupInfo)];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "workspaces/".concat(workspaceSetupInfo.workspaceId, "/setup"),
                                workspaceData,
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getWorkspaceUsage', function () {
            it('should return workspace usage when getWorkspaceUsage is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, usageResponse, getCall, response;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            usageResponse = {
                                totalWorkspaceSpace: 1024 * 1024 * 1024 * 2,
                                spaceAssigned: 1024 * 1024 * 1024 * 1.5,
                                spaceUsed: 1024 * 1024 * 1024 * 1,
                            };
                            getCall = sinon_1.default.stub(httpClient, 'get').resolves(usageResponse);
                            return [4 /*yield*/, client.getWorkspaceUsage(workspaceId)];
                        case 1:
                            response = _b.sent();
                            expect(getCall.firstCall.args).toEqual(["workspaces/".concat(workspaceId, "/usage"), headers]);
                            expect(response).toEqual(usageResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getWorkspacesTeams', function () {
            it('should return the teams of a workspace when getWorkspacesTeams is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceId, workspaceTeamsResponse, client, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            workspaceId = 'workspaceId';
                            workspaceTeamsResponse = [
                                {
                                    membersCount: 3,
                                    team: {
                                        id: 'team1',
                                        name: 'Team 1',
                                        managerId: 'manager1',
                                        workspaceId: 'workspace1',
                                        createdAt: '2024-04-30T12:00:00Z',
                                        updatedAt: '2024-04-30T12:00:00Z',
                                    },
                                },
                                {
                                    membersCount: 5,
                                    team: {
                                        id: 'team2',
                                        name: 'Team 2',
                                        managerId: 'manager2',
                                        workspaceId: 'workspace1',
                                        createdAt: '2024-04-30T12:00:00Z',
                                        updatedAt: '2024-04-30T12:00:00Z',
                                    },
                                },
                                {
                                    membersCount: 2,
                                    team: {
                                        id: 'team3',
                                        name: 'Team 3',
                                        managerId: 'manager3',
                                        workspaceId: 'workspace2',
                                        createdAt: '2024-04-30T12:00:00Z',
                                        updatedAt: '2024-04-30T12:00:00Z',
                                    },
                                },
                            ];
                            client = clientAndHeaders().client;
                            sinon_1.default.stub(httpClient, 'get').resolves(workspaceTeamsResponse);
                            return [4 /*yield*/, client.getWorkspacesTeams(workspaceId)];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(workspaceTeamsResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('createTeam', function () {
            it('should create a team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamData, createTeamData, _a, client, headers, postCall, response;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamData = { name: 'team', managerId: 'asdf-123ad-f123' };
                            createTeamData = __assign({ workspaceId: '123sdf' }, teamData);
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            postCall = sinon_1.default.stub(httpClient, 'post').resolves({ status: 200 });
                            return [4 /*yield*/, client.createTeam(createTeamData)];
                        case 1:
                            response = _b.sent();
                            expect(postCall.firstCall.args).toEqual(['workspaces/123sdf/teams', teamData, headers]);
                            expect(response).toEqual({ status: 200 });
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('editTeam', function () {
            it('should edit the team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamId, newName, _a, client, headers, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamId = 'teamId';
                            newName = 'New Team Name';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.editTeam({ teamId: teamId, name: newName })];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual(["workspaces/teams/".concat(teamId), { name: newName }, headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('deleteTeam', function () {
            it('should delete the team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceId, teamId, _a, client, headers, deleteCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            workspaceId = 'workspaceId';
                            teamId = 'teamId';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            deleteCall = sinon_1.default.stub(httpClient, 'delete').resolves();
                            return [4 /*yield*/, client.deleteTeam({ workspaceId: workspaceId, teamId: teamId })];
                        case 1:
                            _b.sent();
                            expect(deleteCall.firstCall.args).toEqual(["workspaces/".concat(workspaceId, "/teams/").concat(teamId), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getWorkspacesTeamMembers', function () {
            it('should return the members of a team when getWorkspacesTeamMembers is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamId, _a, client, headers, getCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamId = 'teamId';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            getCall = sinon_1.default.stub(httpClient, 'get').resolves();
                            return [4 /*yield*/, client.getWorkspacesTeamMembers(teamId)];
                        case 1:
                            _b.sent();
                            expect(getCall.firstCall.args).toEqual(["workspaces/teams/".concat(teamId, "/members"), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('addTeamUser', function () {
            it('should add a user to the team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamId, userUuid, _a, client, headers, postCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamId = 'teamId';
                            userUuid = 'userUuid';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            postCall = sinon_1.default.stub(httpClient, 'post').resolves();
                            return [4 /*yield*/, client.addTeamUser(teamId, userUuid)];
                        case 1:
                            _b.sent();
                            expect(postCall.firstCall.args).toEqual(["/workspaces/teams/".concat(teamId, "/user/").concat(userUuid), {}, headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('removeTeamUser', function () {
            it('should remove a user from the team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamId, userUuid, _a, client, headers, deleteCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamId = 'teamId';
                            userUuid = 'userUuid';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            deleteCall = sinon_1.default.stub(httpClient, 'delete').resolves();
                            return [4 /*yield*/, client.removeTeamUser(teamId, userUuid)];
                        case 1:
                            _b.sent();
                            expect(deleteCall.firstCall.args).toEqual(["/workspaces/teams/".concat(teamId, "/user/").concat(userUuid), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('changeTeamManager', function () {
            it('should change the team manager successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceId, teamId, userUuid, _a, client, headers, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            workspaceId = 'workspaceId';
                            teamId = 'teamId';
                            userUuid = 'userUuid';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.changeTeamManager(workspaceId, teamId, userUuid)];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "/workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/manager"),
                                { managerId: userUuid },
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('changeUserRole', function () {
            it('should change the user role in the team successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var teamId, memberId, role, _a, client, headers, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            teamId = 'teamId';
                            memberId = 'memberId';
                            role = 'newRole';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.changeUserRole(teamId, memberId, role)];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "/api/workspaces/teams/".concat(teamId, "/members/").concat(memberId, "/role"),
                                { role: role },
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('inviteMemberToWorkspace', function () {
            it('should invite a member to the workspace successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceId, invitedUserEmail, spaceLimitBytes, encryptedMnemonicInBase64, encryptionAlgorithm, _a, client, headers, postCall, message;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            workspaceId = 'workspaceId';
                            invitedUserEmail = 'test@example.com';
                            spaceLimitBytes = 1024;
                            encryptedMnemonicInBase64 = 'encryptedMnemonic';
                            encryptionAlgorithm = 'aes-256-gcm';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            postCall = sinon_1.default.stub(httpClient, 'post').resolves();
                            message = 'Test message';
                            return [4 /*yield*/, client.inviteMemberToWorkspace({
                                    workspaceId: workspaceId,
                                    invitedUserEmail: invitedUserEmail,
                                    spaceLimitBytes: spaceLimitBytes,
                                    encryptedMnemonicInBase64: encryptedMnemonicInBase64,
                                    encryptionAlgorithm: encryptionAlgorithm,
                                    message: message,
                                })];
                        case 1:
                            _b.sent();
                            expect(postCall.firstCall.args).toEqual([
                                "workspaces/".concat(workspaceId, "/members/invite"),
                                {
                                    invitedUser: invitedUserEmail,
                                    spaceLimit: spaceLimitBytes,
                                    encryptionKey: encryptedMnemonicInBase64,
                                    encryptionAlgorithm: 'aes-256-gcm',
                                    message: message,
                                },
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('modifyMemberUsage', function () {
            it('should modify the member usage limit successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, memberId, spaceLimitBytes, workspaceUserResponse, patchCall, response;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            memberId = 'memberId';
                            spaceLimitBytes = 1024 * 1024 * 1024;
                            workspaceUserResponse = {
                                id: 'memberId',
                                spaceLimit: '1GB',
                                driveUsage: '500MB',
                                backupsUsage: '200MB',
                                deactivated: false,
                                member: {
                                    id: 1,
                                    name: 'MemberName',
                                    lastname: 'MemberLastName',
                                    email: 'email@email.com',
                                },
                            };
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves(workspaceUserResponse);
                            return [4 /*yield*/, client.modifyMemberUsage(workspaceId, memberId, spaceLimitBytes)];
                        case 1:
                            response = _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "workspaces/".concat(workspaceId, "/members/").concat(memberId, "/usage"),
                                { spaceLimit: spaceLimitBytes },
                                headers,
                            ]);
                            expect(response).toEqual(workspaceUserResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getPendingInvites', function () {
            it('should return the pending invites when getPendingInvites is called', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, pendingInvitesResponse, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            pendingInvitesResponse = [
                                {
                                    id: '1',
                                    workspaceId: 'workspace1',
                                    invitedUser: 'user1',
                                    encryptionAlgorithm: 'AES',
                                    encryptionKey: 'key1',
                                    spaceLimit: 100,
                                    createdAt: new Date(),
                                    updatedAt: new Date(),
                                    workspace: {
                                        address: '123 Main St',
                                        createdAt: '2024-04-30T12:00:00Z',
                                        updatedAt: '2024-04-30T12:00:00Z',
                                        defaultTeamId: 'team1',
                                        description: 'Description for Workspace 1',
                                        id: 'workspace1',
                                        name: 'Workspace 1',
                                        ownerId: 'owner1',
                                        setupCompleted: true,
                                        workspaceUserId: '1',
                                        avatar: null,
                                        rootFolderId: 'asdf-123-asdf',
                                        phoneNumber: null,
                                    },
                                },
                            ];
                            sinon_1.default.stub(httpClient, 'get').resolves(pendingInvitesResponse);
                            return [4 /*yield*/, client.getPendingInvites()];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(pendingInvitesResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('validateWorkspaceInvite', function () {
            it('should return the inviteId successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, inviteId, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            inviteId = 'inviteId';
                            sinon_1.default.stub(httpClient, 'get').resolves(inviteId);
                            return [4 /*yield*/, client.validateWorkspaceInvite(inviteId)];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(inviteId);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('deleteWorkspaceAvatar', function () {
            it('should delete the workspace avatar successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspaceId, _a, client, headers, deleteCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            workspaceId = 'workspaceId';
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            deleteCall = sinon_1.default.stub(httpClient, 'delete').resolves();
                            return [4 /*yield*/, client.deleteWorkspaceAvatar(workspaceId)];
                        case 1:
                            _b.sent();
                            expect(deleteCall.firstCall.args).toEqual(["workspaces/".concat(workspaceId, "/avatar"), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getWorkspaceCredentials', function () {
            it('should return the workspace credentials successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, workspaceId, getWorkspaceCredentialsResponse, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            workspaceId = 'workspaceId';
                            getWorkspaceCredentialsResponse = {
                                workspaceId: workspaceId,
                                bucket: 'bucket',
                                workspaceUserId: 'workspaceUserId',
                                email: 'email',
                                credentials: {
                                    networkPass: 'networkPass',
                                    networkUser: 'networkUser',
                                },
                                tokenHeader: 'tokenHeader',
                            };
                            sinon_1.default.stub(httpClient, 'get').resolves(getWorkspaceCredentialsResponse);
                            return [4 /*yield*/, client.getWorkspaceCredentials(workspaceId)];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(getWorkspaceCredentialsResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getPersonalTrash', function () {
            it('should return the personal trash successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, workspaceId, getPersonalTrashResponse, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            workspaceId = 'workspaceId';
                            getPersonalTrashResponse = {
                                bucket: 'bucket',
                                files: [],
                                folders: [],
                            };
                            sinon_1.default.stub(httpClient, 'get').resolves(getPersonalTrashResponse);
                            return [4 /*yield*/, client.getPersonalTrash(workspaceId, 'file')];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(getPersonalTrashResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('emptyPersonalTrash', function () {
            it('should empty the personal trash successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, deleteCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            deleteCall = sinon_1.default.stub(httpClient, 'delete').resolves();
                            return [4 /*yield*/, client.emptyPersonalTrash(workspaceId)];
                        case 1:
                            _b.sent();
                            expect(deleteCall.firstCall.args).toEqual(["/workspaces/".concat(workspaceId, "/trash"), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('editWorkspace', function () {
            it('should edit the workspace details successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, workspaceData, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            workspaceData = {
                                name: 'Workspace Name',
                                description: 'Workspace Description',
                                address: 'Workspace Address',
                            };
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.editWorkspace(workspaceId, {
                                    description: workspaceData.description,
                                    name: workspaceData.name,
                                    address: workspaceData.address,
                                })];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual(["workspaces/".concat(workspaceId), workspaceData, headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('leaveWorkspace', function () {
            it('should leave the workspace successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, deleteCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            deleteCall = sinon_1.default.stub(httpClient, 'delete').resolves();
                            return [4 /*yield*/, client.leaveWorkspace(workspaceId)];
                        case 1:
                            _b.sent();
                            expect(deleteCall.firstCall.args).toEqual(["workspaces/".concat(workspaceId, "/members/leave"), headers]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getMemberDetails', function () {
            it('should return the member details successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var client, memberId, getMemberDetailsResponse, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            client = clientAndHeaders().client;
                            memberId = 'memberId';
                            getMemberDetailsResponse = {
                                user: {
                                    avatar: null,
                                    backupsUsage: '1324',
                                    deactivated: false,
                                    driveUsage: '12332411',
                                    email: 'email@email.com',
                                    id: 123,
                                    lastname: 'Lastname',
                                    memberId: 'memberId',
                                    name: 'Name',
                                    spaceLimit: '5368709120',
                                    uuid: 'asflaksfoau0su0fewnlsd',
                                    workspaceId: 'workspaceId',
                                },
                                teams: [
                                    {
                                        isManager: false,
                                        id: 'teamId',
                                        name: 'teamName',
                                        managerId: 'managerId',
                                        createdAt: '2024-04-30T12:00:00Z',
                                        updatedAt: '2024-04-30T12:00:00Z',
                                        workspaceId: 'workspaceId',
                                    },
                                ],
                            };
                            sinon_1.default.stub(httpClient, 'get').resolves(getMemberDetailsResponse);
                            return [4 /*yield*/, client.getMemberDetails('workspaceId', memberId)];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(getMemberDetailsResponse);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('deactivateMember', function () {
            it('should deactivate the member successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, memberId, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            memberId = 'memberId';
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.deactivateMember(workspaceId, memberId)];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "workspaces/".concat(workspaceId, "/members/").concat(memberId, "/deactivate"),
                                {},
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('activateMember', function () {
            it('should activate the member successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var _a, client, headers, workspaceId, memberId, patchCall;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = clientAndHeaders(), client = _a.client, headers = _a.headers;
                            workspaceId = 'workspaceId';
                            memberId = 'memberId';
                            patchCall = sinon_1.default.stub(httpClient, 'patch').resolves();
                            return [4 /*yield*/, client.activateMember(workspaceId, memberId)];
                        case 1:
                            _b.sent();
                            expect(patchCall.firstCall.args).toEqual([
                                "workspaces/".concat(workspaceId, "/members/").concat(memberId, "/activate"),
                                {},
                                headers,
                            ]);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
        describe('getWorkspace', function () {
            it('should return the workspace billing address successfully', function () { return __awaiter(void 0, void 0, void 0, function () {
                var workspace, client, workspaceId, response;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            workspace = {
                                id: 'workspace2',
                                ownerId: 'owner2',
                                address: '456 Elm St',
                                name: 'Workspace 2',
                                description: 'Description for Workspace 2',
                                defaultTeamId: 'team2',
                                workspaceUserId: '2',
                                setupCompleted: true,
                                createdAt: '2024-04-30T12:00:00Z',
                                updatedAt: '2024-04-30T12:00:00Z',
                                avatar: null,
                                rootFolderId: 'asflaksfoau0su0fewnlsd',
                            };
                            client = clientAndHeaders().client;
                            workspaceId = 'workspaceId';
                            sinon_1.default.stub(httpClient, 'get').resolves(workspace);
                            return [4 /*yield*/, client.getWorkspace(workspaceId)];
                        case 1:
                            response = _a.sent();
                            expect(response).toEqual(workspace);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    });
});
function clientAndHeaders(apiUrl, clientName, clientVersion, token, workspaceToken) {
    if (apiUrl === void 0) { apiUrl = ''; }
    if (clientName === void 0) { clientName = 'c-name'; }
    if (clientVersion === void 0) { clientVersion = '0.1'; }
    if (token === void 0) { token = 'my-token'; }
    if (workspaceToken === void 0) { workspaceToken = 'workspaceToken'; }
    var appDetails = {
        clientName: clientName,
        clientVersion: clientVersion,
    };
    var apiSecurity = {
        token: token,
        workspaceToken: workspaceToken,
    };
    var client = index_1.Workspaces.client(apiUrl, appDetails, apiSecurity);
    var headers = (0, headers_1.headersWithToken)({ clientName: clientName, clientVersion: clientVersion, token: token, workspaceToken: workspaceToken });
    return { client: client, headers: headers };
}
