"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAxiosErrorMessage = extractAxiosErrorMessage;
exports.isHexString = isHexString;
function extractAxiosErrorMessage(err) {
    var errMsg;
    var error = err;
    var isServerError = !!error.response;
    var serverUnavailable = !!error.request;
    if (isServerError) {
        errMsg = error.response.data.error;
    }
    else if (serverUnavailable) {
        errMsg = 'Server not available';
    }
    else {
        errMsg = error.message;
    }
    return errMsg;
}
function isHexString(string) {
    // TODO: replace with proper library
    return /^([0-9a-fA-F]{2})+$/.test(string);
}
