export type NetworkUploadContext = {
    bucketId: string;
    fileSize: number;
    user: string;
    crypto: {
        mnemonic?: string;
    };
};
export type NetworkDownloadContext = {
    bucketId: string;
    fileId: string;
    user: string;
    crypto: {
        mnemonic?: string;
    };
};
export type NetworkContext = NetworkUploadContext | NetworkDownloadContext;
export declare class ErrorWithContext extends Error {
    context: NetworkContext;
    constructor(context: NetworkContext);
}
export declare function getNetworkErrorContext(input: NetworkContext, err: unknown): NetworkContext;
