"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Share = exports.ShareTypes = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
exports.ShareTypes = __importStar(require("./types"));
var Share = /** @class */ (function () {
    function Share(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Share.client = function (apiUrl, appDetails, apiSecurity) {
        return new Share(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Fetches the list of shared items
     */
    Share.prototype.getShareLinks = function (page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("/storage/share/list?page=".concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Creates a new link to share a file or folder
     * @param payload
     */
    Share.prototype.createShareLink = function (payload) {
        var types = ['file', 'folder'];
        if (!types.includes(payload.type)) {
            throw new Error('Invalid type');
        }
        return this.client.post("/storage/share/".concat(payload.type, "/").concat(payload.itemId), {
            timesValid: payload.timesValid,
            encryptedMnemonic: payload.encryptedMnemonic,
            itemToken: payload.itemToken,
            bucket: payload.bucket,
            encryptedCode: payload.encryptedCode,
            plainPassword: payload.plainPassword,
        }, this.headers());
    };
    /**
     * Update share link
     * @param payload
     */
    Share.prototype.updateShareLink = function (payload) {
        return this.client.put("/storage/share/".concat(payload.itemId), {
            plainPassword: payload.plainPassword,
        }, this.headers());
    };
    /**
     * Delete share link by id
     * @param payload
     */
    Share.prototype.deleteShareLink = function (shareId) {
        return this.client.delete("/storage/share/".concat(shareId), this.headers());
    };
    /**
     * Increment share view by token
     * @param token
     */
    Share.prototype.incrementShareViewByToken = function (token) {
        return this.client.put("/storage/share/".concat(token, "/view"), {}, this.headers());
    };
    /**
     * Fetches data of a shared file
     * @param token
     */
    Share.prototype.getShareLink = function (token, password) {
        var headers = password ? this.basicHeadersWithPassword(password) : this.basicHeaders();
        return this.client.get("/storage/share/".concat(token), headers);
    };
    /**
     * Fetches paginated folders or files of a specific share link
     * @param payload
     */
    Share.prototype.getShareLinkDirectory = function (payload) {
        var types = ['file', 'folder'];
        if (!types.includes(payload.type)) {
            throw new Error('Invalid type');
        }
        var headers = this.basicHeaders();
        if (payload.password) {
            headers = this.basicHeadersWithPassword(payload.password);
        }
        return this.client.get("/storage/share/down/".concat(payload.type, "s?token=").concat(payload.token, "&folderId=").concat(payload.folderId, "&parentId=").concat(payload.parentId, "&page=").concat(payload.page, "&perPage=").concat(payload.perPage).concat(payload.code ? '&code=' + payload.code : ''), headers);
    };
    Share.prototype.getShareDomains = function () {
        return this.client.get('/storage/share/domains', this.headers());
    };
    /**
     * Get size of folder in share links
     * @param payload
     */
    Share.prototype.getShareLinkFolderSize = function (payload) {
        return this.client.get("/storage/share/".concat(payload.itemId, "/folder/").concat(payload.folderId, "/size"), this.basicHeaders());
    };
    /**
     * Fetches all folders shared by a user.
     *
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     * @returns {Promise<ListPrivateSharedFoldersResponse>} A promise containing the list of shared folders.
     */
    Share.prototype.getSentSharedFolders = function (page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/shared-by-me/folders?page=".concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Fetches folders shared with a user.
     *
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     * @returns {Promise<ListPrivateSharedFoldersResponse>} A promise containing the list of shared folders.
     */
    Share.prototype.getReceivedSharedFolders = function (page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/shared-with-me/folders?page=".concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Fetches all shared folders.
     *
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     * @returns {Promise<ListAllSharedFoldersResponse>} A promise containing the list of shared folders.
     */
    Share.prototype.getAllSharedFolders = function (page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/folders?page=".concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Fetches all shared files.
     *
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     * @returns {Promise<ListAllSharedFoldersResponse>} A promise containing the list of shared folders.
     */
    Share.prototype.getAllSharedFiles = function (page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/files?page=".concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Get all users with access to a shared folder.
     *
     * @param {string} folderUUID - The UUID of the folder.
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     * @returns {Promise<{ users: SharedFolderUser[] }>} A promise containing the list of users with access to the folder.
     */
    Share.prototype.getSharedFolderUsers = function (folderUUID, page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/shared-with/".concat(folderUUID, "?page=").concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Get shared folder content
     * @param {string} sharedFolderId - The UUID of the shared folder.
     * @param {string} type - The item type for the query folders/files
     * @param {string} token - Key that enables invited users to navigate the folders
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     */
    Share.prototype.getSharedFolderContent = function (sharedFolderId, type, token, page, perPage, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get("sharings/items/".concat(sharedFolderId, "/").concat(type, "?token=").concat(token, "&page=").concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Get public shared folder content
     * @param {string} sharedFolderId - The UUID of the shared folder.
     * @param {string} type - The item type for the query folders/files
     * @param {string} token - Key that enables invited users to navigate the folders
     * @param {number} page - The page number for pagination.
     * @param {number} perPage - The number of items per page for pagination.
     * @param {string} [orderBy] - The optional order criteria (e.g., 'views:ASC', 'createdAt:DESC').
     */
    Share.prototype.getPublicSharedFolderContent = function (sharedFolderId, type, token, page, perPage, code, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        if (code === void 0) { code = ''; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        return this.client.get(
        // eslint-disable-next-line max-len
        "sharings/public/items/".concat(sharedFolderId, "/").concat(type, "?token=").concat(token, "&code=").concat(code, "&page=").concat(page, "&perPage=").concat(perPage).concat(orderByQueryParam), this.headers());
    };
    /**
     * Get the role of a user on a folder.
     *
     * @param {string} options.sharingId - The unique identifier of the sharing.
     * @returns {Promise<Role>} A promise containing the role of the current user in the sharing.
     */
    Share.prototype.getUserRole = function (sharingId) {
        return this.client.get("sharings/".concat(sharingId, "/role"), this.headers());
    };
    /**
     * Update the role of a user on a folder.
     *
     * @param {UpdateUserRolePayload} options - The options for updating the user's role on the folder.
     * @param {string} options.sharingId - The unique identifier of the user to whom we will update the role.
     * @param {string} options.newRoleId - The new role Id.
     * @returns {Promise<UpdateRoleFolderResponse>} A promise that resolves when the user's role is updated.
     */
    Share.prototype.updateUserRole = function (_a) {
        var sharingId = _a.sharingId, newRoleId = _a.newRoleId;
        return this.client.put("sharings/".concat(sharingId, "/role"), {
            roleId: newRoleId,
        }, this.headers());
    };
    /**
     * Remove user from shared folder.
     *
     * @param {UpdateUserRolePayload} options - The options for updating the user's role on the folder.
     * @param {string} options.itemType - The unique identifier of the folder.
     * @param {string} options.itemId - The identifier of the role to assign to the user.
     * @param {string} options.userId - The role Id how we want to delete.
     * @returns {Promise<UpdateRoleFolderResponse>} A promise that resolves when the user's role is updated.
     */
    Share.prototype.removeUserRole = function (_a) {
        var itemType = _a.itemType, itemId = _a.itemId, userId = _a.userId;
        return this.client.delete("sharings/".concat(itemType, "/").concat(itemId, "/users/").concat(userId), this.headers());
    };
    /**
     * Get private folder data.
     *
     * @param {string} itemId - The itemId of the folder.
     * @param {string} itemType - The itemType of the folder (file | folder).
     * @returns {Promise<{ data: SharingInvite[] }>} A promise containing the private folder data.
     */
    Share.prototype.getSharedFolderInvitations = function (_a) {
        var itemId = _a.itemId, itemType = _a.itemType;
        return this.client.get("sharings/".concat(itemType, "/").concat(itemId, "/invites"), this.headers());
    };
    /**
     * Get all invitations for a user.
     * @param limit - The number of items per page for pagination.
     * @param offset - The page number for pagination.
     * @returns {Promise<invites: any>} A promise containing the list of invitations.
     */
    Share.prototype.getSharedFolderInvitationsAsInvitedUser = function (_a) {
        var limit = _a.limit, offset = _a.offset;
        return this.client.get("sharings/invites?limit=".concat(limit, "&offset=").concat(offset), this.headers());
    };
    /**
     * Share a private folder with a user.
     *
     * @param {ShareFolderWithUserPayload} options - The options for sharing the private folder with a user.
     * @param {string} options.itemId - The id of the item to share.
     * @param {string} options.itemType - The type of the item to share (folder | file).
     * @param {string} options.sharedWith - The email address of the user to share the folder with.
     * @param {string} options.encryptionKey - Owner\'s encryption key encrypted with the invited user\'s public key. This field should not be empty if the invitation type is "OWNER".
     * @param {string} options.encryptionAlgorithm - Encryption algorithm used to encrypt the encryption key. This field should not be empty if the invitation type is "OWNER".
     * @param {string} options.type - Owner's encryption key encrypted with the invited user's public key.
     * @param {string} options.roleId - The id of the role to assign to the user.
     * @param {string} options.notifyUser - If it has to notify the users
     * @param {string} options.notificationMessage - Message of the notificacion
     *
     *
     * @returns {Promise<SharingInvite>} A promise that resolves when the folder is shared with the user.
     */
    Share.prototype.inviteUserToSharedFolder = function (createInviteDto) {
        return this.client.post('sharings/invites/send', __assign(__assign({}, createInviteDto), { type: 'OWNER' }), this.headers());
    };
    /**
     * Create a sharing.
     */
    Share.prototype.createSharing = function (createSharingPayload) {
        return this.client.post('sharings', __assign({}, createSharingPayload), this.headers());
    };
    /**
     * Get sharing meta with code
     */
    Share.prototype.getSharingMeta = function (sharingId, code, password) {
        var extraHeaders = password ? { 'x-share-password': password } : {};
        return this.client.get("sharings/".concat(sharingId, "/meta?code=").concat(code), __assign(__assign({}, this.headers()), extraHeaders));
    };
    /**
     * Add/edit sharing Password
     * @param {string} sharingId - id of sharing.
     * @param {string} encryptedPassword - password encrypted with CODE as key
     * @returns {Promise<SharingMeta>} A promise that returns the sharing info with the new encrypted password
     */
    Share.prototype.saveSharingPassword = function (sharingId, encryptedPassword) {
        return this.client.patch("sharings/".concat(sharingId, "/password"), {
            encryptedPassword: encryptedPassword,
        }, this.headers());
    };
    /**
     * Remove password protection from sharing
     * @param {string} sharingId - id of sharing.
     * @returns {Promise<void>} A promise that resolves when password was successfully deleted.
     */
    Share.prototype.removeSharingPassword = function (sharingId) {
        return this.client.delete("sharings/".concat(sharingId, "/password"), this.headers());
    };
    /**
     * Get public information of the item shared.
     * @param {string} sharingId - id of sharing.
     * @returns {Promise<PublicSharedItemInfo>} A promise that returns data of the public shared item.
     */
    Share.prototype.getPublicSharedItemInfo = function (sharingId) {
        return this.client.get("sharings/public/".concat(sharingId, "/item"), this.headers());
    };
    /**
     * Request access to shared folder.
     */
    Share.prototype.requestUserToSharedFolder = function (createInviteDto) {
        return this.client.post('sharings/invites/send', __assign(__assign({}, createInviteDto), { type: 'SELF' }), this.headers());
    };
    /**
     * Check if the expirationDate of invite is valid.
     * @param {string} invitationId - The id of the invitation.
     
     * @returns {Promise<{uuid: string}>}  A promise returning the uuid of the invitation if valid.
     */
    Share.prototype.validateInviteExpiration = function (invitationId) {
        return this.client.get("sharings/invites/".concat(invitationId, "/validate"), this.headers());
    };
    /**
     * Share a private folder with a user.
     * @param {string} invitationId - The id of the invitation.
     * @param {ShareFolderWithUserPayload} options - The options for sharing the private folder with a user.
     * @param {string} options.encryptionKey - The encryption key (just in case the invitation is a request).
     * @param {string} options.itemType - The encryption algorithm (just in case the invitation is a request).
     
     * @returns {Promise<void>} A promise that resolves when the folder is shared with the user.
     */
    Share.prototype.acceptSharedFolderInvite = function (_a) {
        var invitationId = _a.invitationId, acceptInvite = _a.acceptInvite, token = _a.token;
        var headers = this.getRequestHeaders(token);
        return this.client.post("sharings/invites/".concat(invitationId, "/accept"), {
            acceptInvite: acceptInvite,
        }, headers);
    };
    /**
     * Change Sharing Mode.
     * @param {string} options.itemType - folder | file
     * @param {string} options.itemId - id of folder or file
     * @param {string} options.sharingType - New Sharing type.
     
     * @returns {Promise<void>} A promise that resolves when sharing mode has been updated.
     */
    Share.prototype.updateSharingType = function (_a) {
        var itemId = _a.itemId, itemType = _a.itemType, sharingType = _a.sharingType;
        var headers = this.headers();
        return this.client.put("sharings/".concat(itemType, "/").concat(itemId, "/type"), {
            sharingType: sharingType,
        }, headers);
    };
    /**
     * Get Sharing type
     * @param {string} options.itemType - folder | file
     * @param {string} options.itemId - id of folder or file
     * @returns {Promise<SharingMeta>} A promise that returns the sharing data.
     */
    Share.prototype.getSharingType = function (_a) {
        var itemId = _a.itemId, itemType = _a.itemType;
        var headers = this.headers();
        return this.client.get("sharings/".concat(itemType, "/").concat(itemId, "/type"), headers);
    };
    /**
     * Obtains detailed sharing information for a given file or folder
     * @param {string} options.itemType - folder | file
     * @param {string} options.itemId - id of folder or file
     * @returns {Promise<SharingInfo>} A promise that returns information about the shared item.
     */
    Share.prototype.getSharingInfo = function (_a) {
        var itemId = _a.itemId, itemType = _a.itemType;
        var headers = this.headers();
        return this.client.get("sharings/".concat(itemType, "/").concat(itemId, "/info"), headers);
    };
    Share.prototype.declineSharedFolderInvite = function (invitationId, token) {
        var headers = this.getRequestHeaders(token);
        return this.client.delete("sharings/invites/".concat(invitationId), headers);
    };
    /**
     * Fetches roles for sharing items.
     *
     * @returns {Promise<PrivateSharingRolesResponse>} A promise containing the list of sharing roles.
     */
    Share.prototype.getSharingRoles = function () {
        return this.client.get('/sharings/roles', this.headers());
    };
    Share.prototype.getAllAccessUsers = function (_a) {
        var itemType = _a.itemType, folderId = _a.folderId;
        return this.client.get("sharings/shared-with/".concat(itemType, "/").concat(folderId), this.headers());
    };
    /**
     * Stop sharing folder
     * @param {string} itemType - Type of the sharing to delete
     * @param {string} itemId - Id of the sharing to delete
     * @returns
     */
    Share.prototype.stopSharingFolder = function (itemType, itemId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.client.delete("sharings/".concat(itemType, "/").concat(itemId), this.headers())];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Share.prototype.headers = function (password) {
        if (password) {
            return (0, headers_1.headersWithTokenAndPassword)({
                clientName: this.appDetails.clientName,
                clientVersion: this.appDetails.clientVersion,
                token: this.apiSecurity.token,
                workspaceToken: this.apiSecurity.workspaceToken,
                desktopToken: this.appDetails.desktopHeader,
                password: password,
            });
        }
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Share.prototype.basicHeaders = function () {
        return (0, headers_1.basicHeaders)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    /**
     * Used to send the password in shares
     * @private
     */
    Share.prototype.basicHeadersWithPassword = function (password) {
        return (0, headers_1.basicHeadersWithPassword)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            desktopToken: this.appDetails.desktopHeader,
            password: password,
        });
    };
    /**
     * Get request headers with optional authorization token.
     *
     * @param {string} [token] - Optional authorization token.
     * @returns {Object} - Request headers object.
     */
    Share.prototype.getRequestHeaders = function (token) {
        var headers = __assign({}, this.headers());
        if (token) {
            headers.Authorization = 'Bearer ' + token;
        }
        return headers;
    };
    /**
     * Gets the size of a shared folder given sharing id
     *
     * @param {string} sharingId - Sharing ID.
     * @returns {Promise<SharedFolderSize>}
     */
    Share.prototype.getSharedFolderSize = function (id) {
        return this.client.get("sharings/public/".concat(id, "/folder/size"), this.headers());
    };
    return Share;
}());
exports.Share = Share;
