import { PaymentMethodVerification, PaymentMethodVerificationPayload } from '../../payments/types';
import { ApiUrl, AppDetails } from '../../shared';
import { CreatedSubscriptionData } from './types/types';
interface ObjectStoragePlan {
    id: string;
    bytes: number;
    interval: 'year' | 'month' | 'lifetime';
    amount: number;
    currency: string;
    decimalAmount: number;
}
export declare class ObjectStorage {
    private readonly client;
    private readonly appDetails;
    static client(apiUrl: ApiUrl, appDetails: AppDetails): ObjectStorage;
    private constructor();
    getObjectStoragePlanById(priceId: string, currency?: string): Promise<ObjectStoragePlan>;
    getObjectStorageCustomerId({ customerName, email, country, postalCode, companyVatId, }: {
        customerName: string;
        email: string;
        country: string;
        postalCode: string;
        companyVatId?: string;
    }): Promise<{
        customerId: string;
        token: string;
    }>;
    createObjectStorageSubscription({ customerId, priceId, currency, token, promoCodeId, }: {
        customerId: string;
        priceId: string;
        currency: string;
        token: string;
        promoCodeId?: string;
    }): Promise<CreatedSubscriptionData>;
    paymentMethodVerification({ customerId, token, currency, priceId, paymentMethod, }: PaymentMethodVerificationPayload): Promise<PaymentMethodVerification>;
    private headers;
}
export {};
