"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = getItemDisplayName;
/**
 * Given an item returns its display name
 *
 * @param item An item
 * @param item.name Item's name
 * @param item.type Item's type, optional
 * @returns Item's display name
 */
function getItemDisplayName(item) {
    var name = item.name, type = item.type;
    return "".concat(name).concat(type ? '.' + type : '');
}
