"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChunkSizeTransform = void 0;
var stream_1 = require("stream");
var ChunkSizeTransform = /** @class */ (function (_super) {
    __extends(ChunkSizeTransform, _super);
    function ChunkSizeTransform(chunkSize) {
        var _this = _super.call(this) || this;
        _this.chunkSize = chunkSize;
        _this.buffer = Buffer.alloc(0);
        return _this;
    }
    ChunkSizeTransform.prototype._transform = function (chunk, encoding, callback) {
        // Append the incoming chunk to the buffer
        this.buffer = Buffer.concat([this.buffer, chunk]);
        // Process the buffer in chunks of the specified size
        while (this.buffer.length >= this.chunkSize) {
            var chunkToSend = this.buffer.slice(0, this.chunkSize);
            this.buffer = this.buffer.slice(this.chunkSize);
            // Push the chunk downstream
            this.push(chunkToSend);
        }
        callback();
    };
    ChunkSizeTransform.prototype._flush = function (callback) {
        // Push any remaining data in the buffer
        if (this.buffer.length > 0) {
            this.push(this.buffer);
        }
        callback();
    };
    return ChunkSizeTransform;
}(stream_1.Transform));
exports.ChunkSizeTransform = ChunkSizeTransform;
