"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcurrentQueue = void 0;
var async_1 = require("async");
var ConcurrentQueue = /** @class */ (function () {
    function ConcurrentQueue(concurrency, totalTasks, task) {
        if (concurrency === void 0) { concurrency = 1; }
        if (totalTasks === void 0) { totalTasks = 1; }
        var _this = this;
        this.finishedTasks = 0;
        if (concurrency > totalTasks) {
            throw new Error('ConcurrentQueue error: Concurrency can not be greater than total tasks to perform');
        }
        this.totalTasks = totalTasks;
        this.concurrency = concurrency;
        if (task) {
            this.queue = (0, async_1.queue)(function (content, cb) { return __awaiter(_this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    task(content)
                        .then(function () {
                        _this.finishedTasks++;
                        cb();
                    })
                        .catch(cb);
                    return [2 /*return*/];
                });
            }); }, concurrency);
        }
        else {
            this.queue = (0, async_1.queue)(function () { }, 1);
        }
    }
    ConcurrentQueue.prototype.setQueueTask = function (task) {
        var _this = this;
        this.queue = (0, async_1.queue)(function (content, cb) { return __awaiter(_this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                task(content)
                    .then(function () {
                    _this.finishedTasks++;
                    cb();
                })
                    .catch(cb);
                return [2 /*return*/];
            });
        }); }, this.concurrency);
    };
    ConcurrentQueue.prototype.push = function (content) {
        return this.queue.push(content);
    };
    ConcurrentQueue.prototype.end = function (cb) {
        var _this = this;
        if (cb) {
            var intervalId_1 = setInterval(function () {
                if (_this.totalTasks === _this.finishedTasks) {
                    clearInterval(intervalId_1);
                    cb();
                }
            }, 500);
        }
        else {
            return new Promise(function (r) {
                var intervalId = setInterval(function () {
                    if (_this.totalTasks === _this.finishedTasks) {
                        clearInterval(intervalId);
                        r();
                    }
                }, 500);
            });
        }
    };
    return ConcurrentQueue;
}());
exports.ConcurrentQueue = ConcurrentQueue;
