"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadFileV2 = uploadFileV2;
exports.uploadFileMultipart = uploadFileMultipart;
var crypto_1 = require("crypto");
var promises_1 = require("stream/promises");
var undici_1 = require("undici");
var bip39_1 = require("bip39");
var upload_1 = require("@internxt/sdk/dist/network/upload");
var network_1 = require("@internxt/sdk/dist/network");
var crypto_2 = require("../../utils/crypto");
var streams_1 = require("../../utils/streams");
var __1 = require("..");
var errors_1 = __importDefault(require("../download/errors"));
var logger_1 = require("../../utils/logger");
var multipart_1 = require("./multipart");
function putStream(url, fileSize) {
    var formattedUrl = new URL(url);
    var headers = {
        'Content-Type': 'application/octet-stream',
    };
    if (fileSize) {
        headers = __assign(__assign({}, headers), { 'Content-Length': fileSize.toString() });
    }
    return (0, undici_1.pipeline)(formattedUrl, { headers: headers, method: 'PUT' }, function (data) { return data.body; });
}
function uploadFileV2(fileSize, source, bucketId, mnemonic, bridgeUrl, creds, appDetails, notifyProgress, actionState) {
    var _this = this;
    var abortController = new AbortController();
    actionState.once(__1.Events.Upload.Abort, function () {
        abortController.abort();
    });
    var network = network_1.Network.client(bridgeUrl, __assign(__assign({}, appDetails), { customHeaders: __assign({ lib: 'inxt-js' }, appDetails.customHeaders) }), {
        bridgeUser: creds.user,
        userId: (0, crypto_2.sha256)(Buffer.from(creds.pass)).toString('hex'),
    });
    var cipher;
    var progress = new streams_1.ProgressNotifier(fileSize, 2000, { emitClose: false });
    progress.on(streams_1.Events.Progress, function (progress) {
        notifyProgress(progress, null, null);
    });
    return (0, upload_1.uploadFile)(network, {
        validateMnemonic: function (mnemonic) {
            return (0, bip39_1.validateMnemonic)(mnemonic);
        },
        algorithm: network_1.ALGORITHMS.AES256CTR,
        generateFileKey: function (mnemonic, bucketId, index) {
            return (0, crypto_2.GenerateFileKey)(mnemonic, bucketId, index);
        },
        randomBytes: crypto_1.randomBytes,
    }, bucketId, mnemonic, fileSize, function (algorithm, key, iv) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            logger_1.logger.debug('Encrypting file using %s (key %s, iv %s)...', algorithm, key.toString('hex'), iv.toString('hex'));
            if (algorithm !== network_1.ALGORITHMS.AES256CTR.type) {
                throw errors_1.default.uploadUnknownAlgorithmError;
            }
            cipher = (0, crypto_1.createCipheriv)('aes-256-ctr', key, iv);
            return [2 /*return*/];
        });
    }); }, function (url) { return __awaiter(_this, void 0, void 0, function () {
        var hasher, fileHash;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    logger_1.logger.debug('Uploading file to %s...', url);
                    hasher = new streams_1.HashStream();
                    return [4 /*yield*/, (0, promises_1.pipeline)(source, cipher, hasher, progress, putStream(url, fileSize), {
                            signal: abortController.signal,
                        })];
                case 1:
                    _a.sent();
                    fileHash = hasher.getHash().toString('hex');
                    logger_1.logger.debug('File uploaded (hash %s)', fileHash);
                    return [2 /*return*/, fileHash];
            }
        });
    }); });
}
function uploadFileMultipart(fileSize, source, bucketId, mnemonic, bridgeUrl, creds, notifyProgress, actionState, appDetails) {
    var _this = this;
    var abortController = new AbortController();
    actionState.once(__1.Events.Upload.Abort, function () {
        abortController.abort();
    });
    var network = network_1.Network.client(bridgeUrl, __assign(__assign({}, appDetails), { customHeaders: __assign({ lib: 'inxt-js' }, appDetails.customHeaders) }), {
        bridgeUser: creds.user,
        userId: (0, crypto_2.sha256)(Buffer.from(creds.pass)).toString('hex'),
    });
    var cipher;
    var progress = new streams_1.ProgressNotifier(fileSize, 2000, { emitClose: false });
    var partSize = 15 * 1024 * 1024;
    var parts = Math.ceil(fileSize / partSize);
    progress.on(streams_1.Events.Progress, function (progress) {
        notifyProgress(progress, null, null);
    });
    return (0, upload_1.uploadMultipartFile)(network, {
        validateMnemonic: function (mnemonic) {
            return (0, bip39_1.validateMnemonic)(mnemonic);
        },
        algorithm: network_1.ALGORITHMS.AES256CTR,
        generateFileKey: function (mnemonic, bucketId, index) {
            return (0, crypto_2.GenerateFileKey)(mnemonic, bucketId, index);
        },
        randomBytes: crypto_1.randomBytes,
    }, bucketId, mnemonic, fileSize, function (algorithm, key, iv) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            logger_1.logger.debug('Encrypting file using %s (key %s, iv %s)...', algorithm, key.toString('hex'), iv.toString('hex'));
            if (algorithm !== network_1.ALGORITHMS.AES256CTR.type) {
                throw errors_1.default.uploadUnknownAlgorithmError;
            }
            cipher = (0, crypto_1.createCipheriv)('aes-256-ctr', key, iv);
            return [2 /*return*/];
        });
    }); }, function (urls) { return __awaiter(_this, void 0, void 0, function () {
        var hasher, pipelineToFinish, parts, fileHash;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    logger_1.logger.debug('Uploading file to %s...', urls);
                    hasher = new streams_1.HashStream();
                    pipelineToFinish = (0, promises_1.pipeline)(source, cipher, hasher, progress, {
                        signal: abortController.signal,
                    });
                    return [4 /*yield*/, (0, multipart_1.uploadParts)(urls, progress, abortController.signal)];
                case 1:
                    parts = _a.sent();
                    return [4 /*yield*/, pipelineToFinish];
                case 2:
                    _a.sent();
                    if (abortController.signal.aborted) {
                        throw new Error('Process killed by user');
                    }
                    fileHash = hasher.getHash().toString('hex');
                    logger_1.logger.debug('File uploaded (hash %s)', fileHash);
                    return [2 /*return*/, {
                            hash: fileHash,
                            parts: parts,
                        }];
            }
        });
    }); }, parts);
}
