import { Readable } from 'stream';
import { NegotiateContract, UploadParams, UploadStrategy } from './strategy';
import { ActionState } from '../../../api';
import { UploadOptions } from './';
interface Source {
    size: number;
    stream: Readable;
}
interface Params extends UploadParams {
    source: Source;
    concurrency: number;
    useProxy: boolean;
}
export type UploadOneStreamStrategyLabel = 'OneStreamOnly';
export type UploadOneStreamStrategyObject = {
    label: UploadOneStreamStrategyLabel;
    params: Params;
};
export type UploadOneStreamStrategyFunction = (bucketId: string, fileId: string, opts: UploadOptions, strategyObj: UploadOneStreamStrategyObject) => ActionState;
/**
 * TODO:
 * - Fix progress notification.
 * - Clean shardmeta array whenever is possible.
 * - Tests
 */
export declare class UploadOneStreamStrategy extends UploadStrategy {
    private source;
    private abortables;
    private internalBuffer;
    private shardMetas;
    private aborted;
    private concurrency;
    private useProxy;
    private uploadsProgress;
    private progressIntervalId;
    constructor(params: Params);
    getIv(): Buffer;
    getFileEncryptionKey(): Buffer<ArrayBuffer>;
    setIv(iv: Buffer): void;
    setFileEncryptionKey(fk: Buffer): void;
    private startProgressInterval;
    private stopProgressInterval;
    upload(negotiateContract: NegotiateContract): Promise<void>;
    private uploadShard;
    private addToAbortables;
    private handleError;
    abort(): void;
    cleanup(): void;
}
export {};
