import { Readable } from 'stream';
import { NegotiateContract, UploadParams, UploadStrategy } from './strategy';
import { ActionState } from '../../../api';
import { UploadOptions } from './';
interface Source {
    size: number;
    stream: Readable;
}
interface Params extends UploadParams {
    sourceToHash: Source;
    sourceToUpload: Source;
    useProxy: boolean;
}
export type UploadOneShardStrategyLabel = 'OneShardOnly';
export type UploadOneShardStrategyObject = {
    label: UploadOneShardStrategyLabel;
    params: Params;
};
export type UploadOneShardStrategyFunction = (bucketId: string, fileId: string, opts: UploadOptions, strategyObj: UploadOneShardStrategyObject) => ActionState;
/**
 * TODO:
 * - Tests
 */
export declare class UploadOneShardStrategy extends UploadStrategy {
    private sourceToHash;
    private sourceToUpload;
    private abortables;
    private shardMeta?;
    private aborted;
    private useProxy;
    private uploadProgress;
    private encryptProgress;
    private uploadProgressIntervalId;
    private encryptProgressIntervalId;
    constructor(params: Params);
    getIv(): Buffer;
    getFileEncryptionKey(): Buffer<ArrayBuffer>;
    setIv(iv: Buffer): void;
    setFileEncryptionKey(fk: Buffer): void;
    private startNotifyingUploadProgress;
    private stopNotifyingUploadProgress;
    private startNotifyingEncryptProgress;
    private stopNotifyingEncryptProgress;
    upload(negotiateContract: NegotiateContract): Promise<void>;
    private addToAbortables;
    private handleError;
    abort(): void;
}
export {};
