"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadParts = uploadParts;
var async_1 = require("async");
var logger_1 = require("../../utils/logger");
var undici_1 = require("undici");
function uploadPart(partUrl, partStream, signal) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, statusCode, headers, body, _b, _c, _d;
        var _e;
        return __generator(this, function (_f) {
            switch (_f.label) {
                case 0: return [4 /*yield*/, (0, undici_1.request)(partUrl, {
                        signal: signal,
                        body: partStream.stream,
                        method: 'PUT',
                        headers: {
                            'Content-Length': partStream.size.toString(),
                        }
                    })];
                case 1:
                    _a = _f.sent(), statusCode = _a.statusCode, headers = _a.headers, body = _a.body;
                    if (statusCode === 200) {
                        return [2 /*return*/, (_e = headers.etag) === null || _e === void 0 ? void 0 : _e.toString()];
                    }
                    _b = Error.bind;
                    _d = (_c = "Failed to upload part: ".concat(statusCode, " ")).concat;
                    return [4 /*yield*/, body.text()];
                case 2: throw (new (_b.apply(Error, [void 0, _d.apply(_c, [_f.sent()])]))());
            }
        });
    });
}
function uploadParts(partUrls, stream, signal) {
    return __awaiter(this, void 0, void 0, function () {
        var parts, concurrency, partLength, bytesRead, partNumber, partBuffer, uploadQueue, chunk, slice, e_1_1;
        var _this = this;
        var _a, stream_1, stream_1_1;
        var _b, e_1, _c, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    parts = [];
                    concurrency = 10;
                    partLength = 15 * 1024 * 1024;
                    bytesRead = 0;
                    partNumber = 1;
                    partBuffer = Buffer.alloc(0);
                    uploadQueue = (0, async_1.queue)(function (part, callback) { return __awaiter(_this, void 0, void 0, function () {
                        var etag, err_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    logger_1.logger.debug('Uploading part %s of %s => %s bytes', part.source.index, partUrls.length, part.source.size);
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 3, , 4]);
                                    return [4 /*yield*/, uploadPart(part.url, part.source, signal)];
                                case 2:
                                    etag = _a.sent();
                                    if (!etag) {
                                        throw new Error('ETag header was not returned');
                                    }
                                    parts.push({ PartNumber: part.source.index, ETag: etag });
                                    callback();
                                    return [3 /*break*/, 4];
                                case 3:
                                    err_1 = _a.sent();
                                    callback(err_1);
                                    return [3 /*break*/, 4];
                                case 4: return [2 /*return*/];
                            }
                        });
                    }); }, concurrency);
                    _e.label = 1;
                case 1:
                    _e.trys.push([1, 9, 10, 15]);
                    _a = true, stream_1 = __asyncValues(stream);
                    _e.label = 2;
                case 2: return [4 /*yield*/, stream_1.next()];
                case 3:
                    if (!(stream_1_1 = _e.sent(), _b = stream_1_1.done, !_b)) return [3 /*break*/, 8];
                    _d = stream_1_1.value;
                    _a = false;
                    chunk = _d;
                    bytesRead += chunk.length;
                    partBuffer = Buffer.concat([partBuffer, chunk]);
                    _e.label = 4;
                case 4:
                    if (!(uploadQueue.running() >= concurrency)) return [3 /*break*/, 6];
                    return [4 /*yield*/, uploadQueue.unsaturated()];
                case 5:
                    _e.sent();
                    return [3 /*break*/, 4];
                case 6:
                    while (bytesRead >= partLength) {
                        slice = partBuffer.slice(0, partLength);
                        uploadQueue.push({
                            url: partUrls[partNumber - 1],
                            source: {
                                size: slice.length,
                                stream: slice,
                                index: partNumber,
                            },
                        });
                        partBuffer = partBuffer.slice(partLength);
                        bytesRead -= partLength;
                        partNumber += 1;
                    }
                    _e.label = 7;
                case 7:
                    _a = true;
                    return [3 /*break*/, 2];
                case 8: return [3 /*break*/, 15];
                case 9:
                    e_1_1 = _e.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 15];
                case 10:
                    _e.trys.push([10, , 13, 14]);
                    if (!(!_a && !_b && (_c = stream_1.return))) return [3 /*break*/, 12];
                    return [4 /*yield*/, _c.call(stream_1)];
                case 11:
                    _e.sent();
                    _e.label = 12;
                case 12: return [3 /*break*/, 14];
                case 13:
                    if (e_1) throw e_1.error;
                    return [7 /*endfinally*/];
                case 14: return [7 /*endfinally*/];
                case 15:
                    if (bytesRead > 0) {
                        uploadQueue.push({
                            url: partUrls[partNumber - 1],
                            source: {
                                size: partBuffer.length,
                                stream: partBuffer,
                                index: partNumber,
                            },
                        });
                    }
                    _e.label = 16;
                case 16:
                    if (!(uploadQueue.running() > 0 || uploadQueue.length() > 0)) return [3 /*break*/, 18];
                    return [4 /*yield*/, uploadQueue.drain()];
                case 17:
                    _e.sent();
                    return [3 /*break*/, 16];
                case 18: return [2 /*return*/, parts.sort(function (pA, pB) { return pA.PartNumber - pB.PartNumber; })];
            }
        });
    });
}
