import { ActionState, Shard } from '../../../api';
import { DownloadStrategy, DownloadParams } from './strategy';
import { DownloadOptions } from '.';
export interface DownloadOneStreamStrategyParams extends DownloadParams {
    concurrency: number;
    useProxy: boolean;
    chunkSize?: number;
}
export type DownloadOneStreamStrategyLabel = 'OneStreamOnly';
export type DownloadOneStreamStrategyObject = {
    label: DownloadOneStreamStrategyLabel;
    params: DownloadOneStreamStrategyParams;
};
export type DownloadOneStreamStrategyFunction = (bucketId: string, fileId: string, opts: DownloadOptions, strategyObj: DownloadOneStreamStrategyObject) => ActionState;
export declare class DownloadOneStreamStrategy extends DownloadStrategy {
    private abortables;
    private internalBuffer;
    private downloadsProgress;
    private decipher;
    private concurrency;
    private useProxy;
    private progressIntervalId;
    private aborted;
    constructor(params: DownloadOneStreamStrategyParams);
    private startProgressInterval;
    private stopProgressInterval;
    private addAbortable;
    download(mirrors: Shard[]): Promise<void>;
    private cleanup;
    private decryptShard;
    private handleShard;
    private handleError;
    abort(): void;
}
