"use strict";
/**
 * DOWNLOAD ERROR CODES: 1XXX
 * UPLOAD ERROR CODES: 2XXX
 * CRYPTOGRAPHY ERROR CODES: 1/2 + 1XX
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ErrorCodes;
(function (ErrorCodes) {
    ErrorCodes[ErrorCodes["DownloadHashMismatch"] = 1000] = "DownloadHashMismatch";
    ErrorCodes[ErrorCodes["DownloadUnknownAlgorithm"] = 1100] = "DownloadUnknownAlgorithm";
    ErrorCodes[ErrorCodes["UploadUnknownAlgorithm"] = 2100] = "UploadUnknownAlgorithm";
})(ErrorCodes || (ErrorCodes = {}));
var CodeError = /** @class */ (function (_super) {
    __extends(CodeError, _super);
    function CodeError(errorMessage, errorCode) {
        var _this = _super.call(this, "".concat(errorMessage, " (ERRNO: ").concat(errorCode, ")")) || this;
        _this.errorMessage = errorMessage;
        _this.errorCode = errorCode;
        return _this;
    }
    return CodeError;
}(Error));
var DownloadError = /** @class */ (function (_super) {
    __extends(DownloadError, _super);
    function DownloadError(errorCode) {
        var _this = _super.call(this, 'Download failed', errorCode) || this;
        _this.errorCode = errorCode;
        return _this;
    }
    return DownloadError;
}(CodeError));
var UploadError = /** @class */ (function (_super) {
    __extends(UploadError, _super);
    function UploadError(errorCode) {
        var _this = _super.call(this, 'Upload failed', errorCode) || this;
        _this.errorCode = errorCode;
        return _this;
    }
    return UploadError;
}(CodeError));
exports.default = {
    ErrorCodes: ErrorCodes,
    downloadHashMismatchError: new DownloadError(ErrorCodes.DownloadHashMismatch),
    downloadUnknownAlgorithmError: new DownloadError(ErrorCodes.DownloadUnknownAlgorithm),
    uploadUnknownAlgorithmError: new UploadError(ErrorCodes.UploadUnknownAlgorithm)
};
