/**
 * DOWNLOAD ERROR CODES: 1XXX
 * UPLOAD ERROR CODES: 2XXX
 * CRYPTOGRAPHY ERROR CODES: 1/2 + 1XX
 */
declare enum ErrorCodes {
    DownloadHashMismatch = 1000,
    DownloadUnknownAlgorithm = 1100,
    UploadUnknownAlgorithm = 2100
}
declare class CodeError extends Error {
    protected errorMessage: string;
    protected errorCode: number;
    constructor(errorMessage: string, errorCode: number);
}
declare class DownloadError extends CodeError {
    protected errorCode: number;
    constructor(errorCode: number);
}
declare class UploadError extends CodeError {
    protected errorCode: number;
    constructor(errorCode: number);
}
declare const _default: {
    ErrorCodes: typeof ErrorCodes;
    downloadHashMismatchError: DownloadError;
    downloadUnknownAlgorithmError: DownloadError;
    uploadUnknownAlgorithmError: UploadError;
};
export default _default;
