import { Readable, Writable } from 'stream';
import { EventEmitter } from 'events';
import { ContractMeta } from '../api';
import { ShardMeta } from '../lib/models';
import { InxtApiI } from '../services/api';
import { Shard } from './';
type PutUrl = string;
type GetUrl = string;
export declare class ShardObject extends EventEmitter {
    private meta;
    private api;
    private frameId;
    private requests;
    private shard?;
    static Events: {
        NodeTransferFinished: string;
    };
    constructor(api: InxtApiI, frameId: string | null, meta: ShardMeta | null, shard?: Shard);
    get size(): number;
    get hash(): string;
    get index(): number;
    static requestPutTwo(url: string, cb: (err: Error | null, url: PutUrl) => void, useProxy: boolean): void;
    static requestPut(url: string): Promise<PutUrl>;
    static requestGet(url: string, useProxy?: boolean): Promise<GetUrl>;
    static getPutStream(url: PutUrl, useProxy: boolean): Promise<Writable>;
    static putStreamTwo(url: PutUrl, content: Readable, cb: (err: Error | null) => void, useProxy: boolean): Promise<void>;
    negotiateContract(): Promise<ContractMeta>;
    private sendShardToNode;
    abort(): void;
}
export {};
