"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionState = exports.ActionTypes = void 0;
var events_1 = require("events");
var core_1 = require("../lib/core");
var ActionTypes;
(function (ActionTypes) {
    ActionTypes["Download"] = "DOWNLOAD";
    ActionTypes["Upload"] = "UPLOAD";
})(ActionTypes || (exports.ActionTypes = ActionTypes = {}));
var ActionState = /** @class */ (function (_super) {
    __extends(ActionState, _super);
    function ActionState(type) {
        var _this = _super.call(this) || this;
        _this.type = type;
        return _this;
    }
    ActionState.prototype.stop = function () {
        if (this.type === ActionTypes.Download) {
            this.emit(core_1.Events.Download.Abort);
            return;
        }
        if (this.type === ActionTypes.Upload) {
            this.emit(core_1.Events.Upload.Abort);
        }
    };
    return ActionState;
}(events_1.EventEmitter));
exports.ActionState = ActionState;
