"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebDavFolderService = void 0;
const errors_utils_1 = require("../../utils/errors.utils");
const webdav_utils_1 = require("../../utils/webdav.utils");
const async_utils_1 = require("../../utils/async.utils");
const auth_service_1 = require("../../services/auth.service");
const drive_utils_1 = require("../../utils/drive.utils");
class WebDavFolderService {
    dependencies;
    constructor(dependencies) {
        this.dependencies = dependencies;
    }
    getDriveFolderItemFromPath = async (path) => {
        const { url } = await webdav_utils_1.WebDavUtils.getRequestedResource(path, false);
        return await webdav_utils_1.WebDavUtils.getDriveFolderFromResource({
            url,
            driveFolderService: this.dependencies.driveFolderService,
        });
    };
    createFolder = async ({ folderName, parentFolderUuid, }) => {
        const [createFolderPromise] = this.dependencies.driveFolderService.createFolder({
            plainName: folderName,
            parentFolderUuid: parentFolderUuid,
        });
        const newFolder = await createFolderPromise;
        await async_utils_1.AsyncUtils.sleep(500);
        return drive_utils_1.DriveUtils.createFolderResponseToItem(newFolder);
    };
    createParentPathOrThrow = async (parentPath) => {
        const { createFullPath } = await this.dependencies.configService.readWebdavConfig();
        if (!createFullPath) {
            throw new errors_utils_1.ConflictError(`Parent folders not found on Internxt Drive at ${webdav_utils_1.WebDavUtils.decodeUrl(parentPath, false)},
        createFullPath flag is set to: ${createFullPath}`);
        }
        const folders = parentPath.split('/').filter((f) => f.length > 0);
        const { user } = await auth_service_1.AuthService.instance.getAuthDetails();
        return await this.createFolderRecursively(folders, user.rootFolderId);
    };
    async createFolderRecursively(remainingFolders, parentFolderUuid, accumulatedPath = '') {
        const [currentFolderName, ...rest] = remainingFolders;
        const newPath = webdav_utils_1.WebDavUtils.joinURL(accumulatedPath, currentFolderName);
        const folderPath = webdav_utils_1.WebDavUtils.normalizeFolderPath(newPath);
        const folder = (await this.getDriveFolderItemFromPath(folderPath)) ??
            (await this.createFolder({ folderName: currentFolderName, parentFolderUuid }));
        if (rest.length === 0) {
            return folder;
        }
        return await this.createFolderRecursively(rest, folder.uuid, newPath);
    }
}
exports.WebDavFolderService = WebDavFolderService;
