import { ConfigService } from '../../services/config.service';
import { DriveFolderService } from '../../services/drive/drive-folder.service';
import { DriveFolderItem } from '../../types/drive.types';
export declare class WebDavFolderService {
    private readonly dependencies;
    constructor(dependencies: {
        driveFolderService: DriveFolderService;
        configService: ConfigService;
    });
    getDriveFolderItemFromPath: (path: string) => Promise<DriveFolderItem | undefined>;
    createFolder: ({ folderName, parentFolderUuid, }: {
        folderName: string;
        parentFolderUuid: string;
    }) => Promise<DriveFolderItem>;
    createParentPathOrThrow: (parentPath: string) => Promise<DriveFolderItem>;
    private createFolderRecursively;
}
