"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MkcolMiddleware = void 0;
const errors_utils_1 = require("../../utils/errors.utils");
const MkcolMiddleware = (req, _, next) => {
    if (req.method === 'MKCOL') {
        let contentType = req.headers['Content-Type'] ?? req.get('content-type');
        if (contentType && contentType.length > 0) {
            if (Array.isArray(contentType)) {
                contentType = contentType[0];
            }
            contentType = contentType.toLowerCase().trim();
            if (contentType !== 'application/xml' && contentType !== 'text/xml') {
                throw new errors_utils_1.UnsupportedMediaTypeError('Unsupported Media Type');
            }
        }
        if (req.body && Object.keys(req.body).length > 0) {
            throw new errors_utils_1.UnsupportedMediaTypeError('Unsupported Media Type');
        }
    }
    next();
};
exports.MkcolMiddleware = MkcolMiddleware;
