"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dotenv_1 = __importDefault(require("dotenv"));
const webdav_server_1 = require("./webdav-server");
const express_1 = __importDefault(require("express"));
const config_service_1 = require("../services/config.service");
const drive_folder_service_1 = require("../services/drive/drive-folder.service");
const drive_file_service_1 = require("../services/drive/drive-file.service");
const download_service_1 = require("../services/network/download.service");
const auth_service_1 = require("../services/auth.service");
const crypto_service_1 = require("../services/crypto.service");
const trash_service_1 = require("../services/drive/trash.service");
const logger_utils_1 = require("../utils/logger.utils");
const sdk_manager_service_1 = require("../services/sdk-manager.service");
dotenv_1.default.config({ quiet: true });
const init = async () => {
    await config_service_1.ConfigService.instance.ensureInternxtCliDataDirExists();
    await config_service_1.ConfigService.instance.ensureWebdavCertsDirExists();
    await config_service_1.ConfigService.instance.ensureInternxtLogsDirExists();
    const { token } = await auth_service_1.AuthService.instance.getAuthDetails();
    sdk_manager_service_1.SdkManager.init({ token });
    new webdav_server_1.WebDavServer((0, express_1.default)(), config_service_1.ConfigService.instance, drive_file_service_1.DriveFileService.instance, drive_folder_service_1.DriveFolderService.instance, download_service_1.DownloadService.instance, auth_service_1.AuthService.instance, crypto_service_1.CryptoService.instance, trash_service_1.TrashService.instance)
        .start()
        .then()
        .catch((err) => logger_utils_1.webdavLogger.error('Failed to start WebDAV server', err));
};
process.on('uncaughtException', (err) => {
    logger_utils_1.webdavLogger.error('Unhandled exception:', err);
});
init();
