"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MKCOLRequestHandler = void 0;
const webdav_utils_1 = require("../../utils/webdav.utils");
const logger_utils_1 = require("../../utils/logger.utils");
const xml_utils_1 = require("../../utils/xml.utils");
const errors_utils_1 = require("../../utils/errors.utils");
class MKCOLRequestHandler {
    dependencies;
    constructor(dependencies) {
        this.dependencies = dependencies;
    }
    handle = async (req, res) => {
        const { driveFolderService, webDavFolderService } = this.dependencies;
        const resource = await webdav_utils_1.WebDavUtils.getRequestedResource(req.url);
        logger_utils_1.webdavLogger.info(`[MKCOL] Request received for folder at ${resource.url}`);
        const parentDriveFolderItem = (await webDavFolderService.getDriveFolderItemFromPath(resource.parentPath)) ??
            (await webDavFolderService.createParentPathOrThrow(resource.parentPath));
        const driveFolderItem = await webdav_utils_1.WebDavUtils.getDriveFolderFromResource({
            url: resource.url,
            driveFolderService,
        });
        const folderAlreadyExists = !!driveFolderItem;
        if (folderAlreadyExists) {
            logger_utils_1.webdavLogger.info(`[MKCOL] ❌ Folder '${resource.url}' already exists`);
            throw new errors_utils_1.MethodNotAllowed('Folder already exists');
        }
        const newFolder = await webDavFolderService.createFolder({
            folderName: resource.path.base,
            parentFolderUuid: parentDriveFolderItem.uuid,
        });
        logger_utils_1.webdavLogger.info(`[MKCOL] ✅ Folder created with UUID ${newFolder.uuid}`);
        res.status(201).send(xml_utils_1.XMLUtils.toWebDavXML({}, {}));
    };
}
exports.MKCOLRequestHandler = MKCOLRequestHandler;
