"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HEADRequestHandler = void 0;
const webdav_utils_1 = require("../../utils/webdav.utils");
const logger_utils_1 = require("../../utils/logger.utils");
const network_utils_1 = require("../../utils/network.utils");
const errors_utils_1 = require("../../utils/errors.utils");
class HEADRequestHandler {
    dependencies;
    constructor(dependencies) {
        this.dependencies = dependencies;
    }
    handle = async (req, res) => {
        const { driveFileService } = this.dependencies;
        const resource = await webdav_utils_1.WebDavUtils.getRequestedResource(req.url);
        logger_utils_1.webdavLogger.info(`[HEAD] Request received for file at ${resource.url}`);
        try {
            const driveFile = await webdav_utils_1.WebDavUtils.getDriveFileFromResource({
                url: resource.url,
                driveFileService,
            });
            if (!driveFile) {
                throw new errors_utils_1.NotFoundError(`Resource not found on Internxt Drive at ${resource.url}`);
            }
            logger_utils_1.webdavLogger.info(`[HEAD] [${driveFile.uuid}] Found Drive File`);
            const range = req.headers['range'];
            const rangeOptions = network_utils_1.NetworkUtils.parseRangeHeader({
                range,
                totalFileSize: driveFile.size,
            });
            let contentLength = driveFile.size;
            if (rangeOptions) {
                logger_utils_1.webdavLogger.info(`[HEAD] [${driveFile.uuid}] Range request received:`, { rangeOptions });
                contentLength = rangeOptions.rangeSize;
            }
            res.header('Content-Type', 'application/octet-stream');
            res.header('Content-length', contentLength.toString());
            res.status(200).send();
        }
        catch {
            res.header('Content-Type', 'application/octet-stream');
            res.status(200).send();
        }
    };
}
exports.HEADRequestHandler = HEADRequestHandler;
