import { WebDavMethodHandler } from '../../types/webdav.types';
import { Request, Response } from 'express';
import { DriveFileService } from '../../services/drive/drive-file.service';
import { NetworkFacade } from '../../services/network/network-facade.service';
import { DownloadService } from '../../services/network/download.service';
import { CryptoService } from '../../services/crypto.service';
import { AuthService } from '../../services/auth.service';
export declare class GETRequestHandler implements WebDavMethodHandler {
    private readonly dependencies;
    constructor(dependencies: {
        driveFileService: DriveFileService;
        downloadService: DownloadService;
        cryptoService: CryptoService;
        authService: AuthService;
        networkFacade: NetworkFacade;
    });
    handle: (req: Request, res: Response) => Promise<void>;
}
