import { WebDavRequestedResource } from '../types/webdav.types';
import { DriveFolderService } from '../services/drive/drive-folder.service';
import { DriveFileService } from '../services/drive/drive-file.service';
import { DriveFileItem, DriveFolderItem, DriveItem } from '../types/drive.types';
export declare class WebDavUtils {
    static joinURL(...pathComponents: string[]): string;
    static removeHostFromURL(completeURL: string): string;
    static decodeUrl(requestUrl: string, decodeUri?: boolean): string;
    static normalizeFolderPath(path: string): string;
    static getRequestedResource(requestUrl: string, decodeUri?: boolean): Promise<WebDavRequestedResource>;
    static tryGetFileOrFolderMetadata({ url, driveFileService, driveFolderService, }: {
        url: string;
        driveFolderService: DriveFolderService;
        driveFileService: DriveFileService;
    }): Promise<DriveItem | undefined>;
    static getDriveFileFromResource({ url, driveFileService, }: {
        url: string;
        driveFileService: DriveFileService;
    }): Promise<DriveFileItem | undefined>;
    static getDriveFolderFromResource({ url, driveFolderService, }: {
        url: string;
        driveFolderService: DriveFolderService;
    }): Promise<DriveFolderItem | undefined>;
    static getDriveItemFromResource({ resource, driveFolderService, driveFileService, }: {
        resource: WebDavRequestedResource;
        driveFolderService: DriveFolderService;
        driveFileService: DriveFileService;
    }): Promise<DriveItem | undefined>;
}
