"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isImageThumbnailable = exports.isPDFThumbnailable = exports.isFileThumbnailable = exports.ThumbnailConfig = void 0;
exports.ThumbnailConfig = {
    MaxWidth: 300,
    MaxHeight: 300,
    Quality: 100,
    Type: 'png',
};
const imageExtensions = {
    tiff: ['tif', 'tiff'],
    bmp: ['bmp'],
    heic: ['heic'],
    jpg: ['jpg', 'jpeg'],
    gif: ['gif'],
    png: ['png'],
    eps: ['eps'],
    raw: ['raw', 'cr2', 'nef', 'orf', 'sr2'],
    webp: ['webp'],
};
const pdfExtensions = {
    pdf: ['pdf'],
};
const thumbnailableImageExtension = [
    ...imageExtensions['jpg'],
    ...imageExtensions['png'],
    ...imageExtensions['webp'],
    ...imageExtensions['gif'],
    ...imageExtensions['tiff'],
];
const thumbnailablePdfExtension = pdfExtensions['pdf'];
const thumbnailableExtension = [...thumbnailableImageExtension];
const isFileThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailableExtension.includes(fileType.trim().toLowerCase());
};
exports.isFileThumbnailable = isFileThumbnailable;
const isPDFThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailablePdfExtension.includes(fileType.trim().toLowerCase());
};
exports.isPDFThumbnailable = isPDFThumbnailable;
const isImageThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailableImageExtension.includes(fileType.trim().toLowerCase());
};
exports.isImageThumbnailable = isImageThumbnailable;
