"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PM2Utils = void 0;
const node_path_1 = __importDefault(require("node:path"));
const pm2_1 = __importDefault(require("pm2"));
class PM2Utils {
    static WEBDAV_APP_NAME = 'Internxt CLI WebDav';
    static connect() {
        return new Promise((resolve, reject) => {
            pm2_1.default.connect((err) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve();
                }
            });
        });
    }
    static disconnect() {
        pm2_1.default.disconnect();
    }
    static async clean() {
        const list = await this.list();
        if (list.length === 0) {
            return new Promise((resolve, reject) => {
                pm2_1.default.killDaemon((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
        }
    }
    static list() {
        return new Promise((resolve, reject) => {
            pm2_1.default.list((err, processes) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(processes);
                }
            });
        });
    }
    static killWebDavServer() {
        return new Promise((resolve) => {
            pm2_1.default.delete(this.WEBDAV_APP_NAME, () => {
                resolve();
            });
        });
    }
    static webdavServerStatus() {
        return new Promise((resolve, reject) => {
            pm2_1.default.describe(this.WEBDAV_APP_NAME, (err, processDescription) => {
                if (err) {
                    reject(err);
                }
                else if (processDescription.length === 0) {
                    resolve({
                        status: 'offline',
                    });
                }
                else {
                    const process = processDescription[0];
                    resolve({
                        status: (process.pm2_env?.status ?? 'unknown'),
                    });
                }
            });
        });
    }
    static startWebDavServer() {
        return new Promise((resolve, reject) => {
            pm2_1.default.start({
                wait_ready: true,
                script: node_path_1.default.join(__dirname, '../webdav/index.js'),
                name: this.WEBDAV_APP_NAME,
            }, (err) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve();
                }
            });
        });
    }
}
exports.PM2Utils = PM2Utils;
