import pm2 from 'pm2';
export type WebDavProcessStatus = 'online' | 'stopping' | 'stopped' | 'launching' | 'errored' | 'one-launch-status' | 'offline' | 'unknown';
export declare class PM2Utils {
    private static readonly WEBDAV_APP_NAME;
    static connect(): Promise<void>;
    static disconnect(): void;
    static clean(): Promise<void>;
    static list(): Promise<pm2.ProcessDescription[]>;
    static killWebDavServer(): Promise<void>;
    static webdavServerStatus(): Promise<{
        status: WebDavProcessStatus;
    }>;
    static startWebDavServer(): Promise<void>;
}
