import { NetworkCredentials, SelfsignedCert } from '../types/network.types';
import selfsigned from 'selfsigned';
import parseRange from 'range-parser';
import { WebdavConfig } from '../types/command.types';
export declare class NetworkUtils {
    static getAuthFromCredentials(creds: NetworkCredentials): {
        username: string;
        password: string;
    };
    static readonly WEBDAV_SSL_CERTS_PATH: {
        cert: string;
        privateKey: string;
    };
    static generateNewSelfsignedCerts(configs: WebdavConfig): SelfsignedCert;
    static getWebdavSSLCerts(configs: WebdavConfig): Promise<SelfsignedCert>;
    static saveWebdavSSLCerts(pems: selfsigned.GenerateResult): Promise<void>;
    static generateSelfSignedSSLCerts(configs: WebdavConfig): selfsigned.GenerateResult;
    static parseRangeHeader(rangeOptions: {
        range?: string;
        totalFileSize: number;
    }): RangeOptions | undefined;
}
export interface RangeOptions {
    range: string;
    rangeSize: number;
    totalFileSize: number;
    parsed: parseRange.Range;
}
