"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InquirerUtils = void 0;
const prompts_1 = require("@inquirer/prompts");
class InquirerUtils {
    static async prompt(message, options) {
        switch (options.type) {
            case 'password': {
                return (0, prompts_1.password)({ message, mask: false });
            }
            case 'mask': {
                return (0, prompts_1.password)({ message, mask: true });
            }
            case 'confirm': {
                const confirmation = await (0, prompts_1.confirm)({ message, default: options.confirm?.default || false });
                return confirmation ? 'y' : 'n';
            }
            case 'input': {
                return (0, prompts_1.input)({ message });
            }
        }
    }
}
exports.InquirerUtils = InquirerUtils;
