"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormatUtils = void 0;
const dayjs_1 = __importDefault(require("dayjs"));
const utc_1 = __importDefault(require("dayjs/plugin/utc"));
const usage_service_1 = require("../services/usage.service");
dayjs_1.default.extend(utc_1.default);
class FormatUtils {
    static humanFileSize = (size) => {
        const i = size == 0 ? 0 : Math.floor(Math.log(size) / Math.log(1024));
        return Number((size / Math.pow(1024, i)).toFixed(2)) * 1 + ' ' + ['B', 'kB', 'MB', 'GB', 'TB'][i];
    };
    static formatDate = (date) => {
        return (0, dayjs_1.default)(date).format('D MMMM, YYYY [at] HH:mm');
    };
    static formatDateForWebDav = (date) => {
        return dayjs_1.default.utc(date).format('ddd, DD MMM YYYY HH:mm:ss [GMT]');
    };
    static formatLimit = (limit) => {
        let result = '...';
        if (limit > 0) {
            result = limit === usage_service_1.UsageService.INFINITE_LIMIT ? 'infinity' : this.humanFileSize(limit);
        }
        return result;
    };
}
exports.FormatUtils = FormatUtils;
