"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotImplementedError = exports.MethodNotAllowed = exports.UnsupportedMediaTypeError = exports.BadRequestError = exports.NotFoundError = exports.ConflictError = exports.ErrorUtils = void 0;
exports.isError = isError;
const logger_utils_1 = require("./logger.utils");
const node_util_1 = require("node:util");
function isError(error) {
    return node_util_1.types.isNativeError(error);
}
class ErrorUtils {
    static report(error, props = {}) {
        if (isError(error)) {
            logger_utils_1.logger.error(`[REPORTED_ERROR]: ${error.message}\nProperties => ${JSON.stringify(props, null, 2)}\nStack => ${error.stack}`);
        }
        else {
            logger_utils_1.logger.error(`[REPORTED_ERROR]: ${JSON.stringify(error)}\nProperties => ${JSON.stringify(props, null, 2)}\n`);
        }
    }
}
exports.ErrorUtils = ErrorUtils;
class ConflictError extends Error {
    statusCode = 409;
    constructor(message) {
        super(message);
        this.name = 'ConflictError';
        Object.setPrototypeOf(this, ConflictError.prototype);
    }
}
exports.ConflictError = ConflictError;
class NotFoundError extends Error {
    statusCode = 404;
    constructor(message) {
        super(message);
        this.name = 'NotFoundError';
        Object.setPrototypeOf(this, NotFoundError.prototype);
    }
}
exports.NotFoundError = NotFoundError;
class BadRequestError extends Error {
    statusCode = 400;
    constructor(message) {
        super(message);
        this.name = 'BadRequestError';
        Object.setPrototypeOf(this, BadRequestError.prototype);
    }
}
exports.BadRequestError = BadRequestError;
class UnsupportedMediaTypeError extends Error {
    statusCode = 415;
    constructor(message) {
        super(message);
        this.name = 'UnsupportedMediaTypeError';
        Object.setPrototypeOf(this, UnsupportedMediaTypeError.prototype);
    }
}
exports.UnsupportedMediaTypeError = UnsupportedMediaTypeError;
class MethodNotAllowed extends Error {
    statusCode = 405;
    constructor(message) {
        super(message);
        this.name = 'MethodNotAllowed';
        Object.setPrototypeOf(this, MethodNotAllowed.prototype);
    }
}
exports.MethodNotAllowed = MethodNotAllowed;
class NotImplementedError extends Error {
    statusCode = 501;
    constructor(message) {
        super(message);
        this.name = 'NotImplementedError';
        Object.setPrototypeOf(this, NotImplementedError.prototype);
    }
}
exports.NotImplementedError = NotImplementedError;
