"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotValidFileError = exports.NotValidDirectoryError = exports.NotValidPortError = exports.EmptyFolderNameError = exports.EmptyFileNameError = exports.InvalidCredentialsError = exports.ExpiredCredentialsError = exports.MissingCredentialsError = exports.NoRootFolderIdFoundError = exports.NotValidFileUuidError = exports.NotValidFolderUuidError = exports.NotValidTwoFactorCodeError = exports.EmptyPasswordError = exports.NotValidEmailError = void 0;
class NotValidEmailError extends Error {
    constructor() {
        super('Email is not valid');
        Object.setPrototypeOf(this, NotValidEmailError.prototype);
    }
}
exports.NotValidEmailError = NotValidEmailError;
class EmptyPasswordError extends Error {
    constructor() {
        super('Password can not be empty');
        Object.setPrototypeOf(this, EmptyPasswordError.prototype);
    }
}
exports.EmptyPasswordError = EmptyPasswordError;
class NotValidTwoFactorCodeError extends Error {
    constructor() {
        super('Two factor auth code is not valid (it must be 6 digit long)');
        Object.setPrototypeOf(this, NotValidTwoFactorCodeError.prototype);
    }
}
exports.NotValidTwoFactorCodeError = NotValidTwoFactorCodeError;
class NotValidFolderUuidError extends Error {
    constructor() {
        super('Folder UUID is not valid (it must be a valid v4 UUID)');
        Object.setPrototypeOf(this, NotValidFolderUuidError.prototype);
    }
}
exports.NotValidFolderUuidError = NotValidFolderUuidError;
class NotValidFileUuidError extends Error {
    constructor() {
        super('File UUID is not valid (it must be a valid v4 UUID)');
        Object.setPrototypeOf(this, NotValidFileUuidError.prototype);
    }
}
exports.NotValidFileUuidError = NotValidFileUuidError;
class NoRootFolderIdFoundError extends Error {
    constructor() {
        super('No root folder id found on your account');
        Object.setPrototypeOf(this, NoRootFolderIdFoundError.prototype);
    }
}
exports.NoRootFolderIdFoundError = NoRootFolderIdFoundError;
class MissingCredentialsError extends Error {
    constructor() {
        super('Missing credentials, please login first');
        Object.setPrototypeOf(this, MissingCredentialsError.prototype);
    }
}
exports.MissingCredentialsError = MissingCredentialsError;
class ExpiredCredentialsError extends Error {
    constructor() {
        super('The session has expired, please login again');
        Object.setPrototypeOf(this, ExpiredCredentialsError.prototype);
    }
}
exports.ExpiredCredentialsError = ExpiredCredentialsError;
class InvalidCredentialsError extends Error {
    constructor() {
        super('Corrupted credentials, please login again');
        Object.setPrototypeOf(this, InvalidCredentialsError.prototype);
    }
}
exports.InvalidCredentialsError = InvalidCredentialsError;
class EmptyFileNameError extends Error {
    constructor() {
        super('File name can not be empty');
        Object.setPrototypeOf(this, EmptyFileNameError.prototype);
    }
}
exports.EmptyFileNameError = EmptyFileNameError;
class EmptyFolderNameError extends Error {
    constructor() {
        super('Folder name can not be empty');
        Object.setPrototypeOf(this, EmptyFolderNameError.prototype);
    }
}
exports.EmptyFolderNameError = EmptyFolderNameError;
class NotValidPortError extends Error {
    constructor() {
        super('Port should be a number between 1 and 65535');
        Object.setPrototypeOf(this, NotValidPortError.prototype);
    }
}
exports.NotValidPortError = NotValidPortError;
class NotValidDirectoryError extends Error {
    constructor() {
        super('The specified path is not a valid directory');
        Object.setPrototypeOf(this, NotValidDirectoryError.prototype);
    }
}
exports.NotValidDirectoryError = NotValidDirectoryError;
class NotValidFileError extends Error {
    constructor() {
        super('The specified path is not a valid file.');
        Object.setPrototypeOf(this, NotValidFileError.prototype);
    }
}
exports.NotValidFileError = NotValidFileError;
