export interface LoginUserDetails {
    userId: string;
    uuid: string;
    email: string;
    name: string;
    lastname: string;
    username: string;
    bridgeUser: string;
    bucket: string;
    rootFolderId: string;
    mnemonic: string;
    keys: {
        ecc: {
            publicKey: string;
            privateKey: string;
        };
        kyber: {
            publicKey: string;
            privateKey: string;
        };
    };
    createdAt: string;
    avatar: string | null;
    emailVerified: boolean;
}
export interface LoginCredentials {
    user: LoginUserDetails;
    token: string;
}
export interface WebdavConfig {
    host: string;
    port: string;
    protocol: 'http' | 'https';
    timeoutMinutes: number;
    createFullPath: boolean;
}
export declare class NotValidEmailError extends Error {
    constructor();
}
export declare class EmptyPasswordError extends Error {
    constructor();
}
export declare class NotValidTwoFactorCodeError extends Error {
    constructor();
}
export declare class NotValidFolderUuidError extends Error {
    constructor();
}
export declare class NotValidFileUuidError extends Error {
    constructor();
}
export declare class NoRootFolderIdFoundError extends Error {
    constructor();
}
export declare class MissingCredentialsError extends Error {
    constructor();
}
export declare class ExpiredCredentialsError extends Error {
    constructor();
}
export declare class InvalidCredentialsError extends Error {
    constructor();
}
export declare class EmptyFileNameError extends Error {
    constructor();
}
export declare class EmptyFolderNameError extends Error {
    constructor();
}
export declare class NotValidPortError extends Error {
    constructor();
}
export declare class NotValidDirectoryError extends Error {
    constructor();
}
export declare class NotValidFileError extends Error {
    constructor();
}
export interface PaginatedItem {
    name: string;
    type: string;
    id: string;
    size: string;
    modified: string;
}
export interface PromptOptions {
    type: 'input' | 'password' | 'mask' | 'confirm';
    confirm?: {
        default: boolean;
    };
}
