"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThumbnailService = void 0;
const node_stream_1 = require("node:stream");
const drive_file_service_1 = require("./drive/drive-file.service");
const drive_1 = require("@internxt/sdk/dist/drive");
const thumbnail_utils_1 = require("../utils/thumbnail.utils");
let sharpDependency = null;
const getSharp = async () => {
    if (!sharpDependency) {
        try {
            sharpDependency = (await Promise.resolve().then(() => __importStar(require('sharp')))).default;
        }
        catch {
            return null;
        }
    }
    return sharpDependency;
};
class ThumbnailService {
    static instance = new ThumbnailService();
    uploadThumbnail = async (fileContent, fileType, userBucket, file_id, networkFacade) => {
        let thumbnailBuffer;
        if ((0, thumbnail_utils_1.isImageThumbnailable)(fileType)) {
            thumbnailBuffer = await this.getThumbnailFromImageBuffer(fileContent);
        }
        if (thumbnailBuffer) {
            const size = thumbnailBuffer.length;
            const fileId = await new Promise((resolve, reject) => {
                networkFacade.uploadFile(node_stream_1.Readable.from(thumbnailBuffer), size, userBucket, (err, res) => {
                    if (err) {
                        return reject(err);
                    }
                    resolve(res);
                }, () => { });
            });
            const createdThumbnailFile = await drive_file_service_1.DriveFileService.instance.createThumbnail({
                fileUuid: file_id,
                maxWidth: thumbnail_utils_1.ThumbnailConfig.MaxWidth,
                maxHeight: thumbnail_utils_1.ThumbnailConfig.MaxHeight,
                type: thumbnail_utils_1.ThumbnailConfig.Type,
                size: size,
                bucketId: userBucket,
                bucketFile: fileId,
                encryptVersion: drive_1.StorageTypes.EncryptionVersion.Aes03,
            });
            return createdThumbnailFile;
        }
    };
    getThumbnailFromImageBuffer = async (buffer) => {
        const sharp = await getSharp();
        if (sharp) {
            return sharp(buffer, { failOnError: false })
                .resize({
                height: thumbnail_utils_1.ThumbnailConfig.MaxHeight,
                width: thumbnail_utils_1.ThumbnailConfig.MaxWidth,
                fit: 'inside',
            })
                .png({
                quality: thumbnail_utils_1.ThumbnailConfig.Quality,
            })
                .toBuffer();
        }
    };
}
exports.ThumbnailService = ThumbnailService;
