import { Auth, Drive, Network as NetworkModule } from '@internxt/sdk';
import { ApiSecurity, AppDetails } from '@internxt/sdk/dist/shared';
export type SdkManagerApiSecurity = ApiSecurity;
export declare class SdkManager {
    static readonly instance: SdkManager;
    private static apiSecurity?;
    static readonly init: (apiSecurity: SdkManagerApiSecurity) => void;
    static readonly clean: () => void;
    static readonly getApiSecurity: (config?: {
        throwErrorOnMissingCredentials: boolean;
    }) => SdkManagerApiSecurity;
    static readonly getAppDetails: () => AppDetails;
    getAuth(): Auth;
    getUsers(): Drive.Users;
    getStorage(): Drive.Storage;
    getTrash(): Drive.Trash;
    getShare(): Drive.Share;
    getNetwork(credentials: {
        user: string;
        pass: string;
    }): NetworkModule.Network;
}
