import { Network } from '@internxt/sdk';
import { Environment } from '@internxt/inxt-js';
import { Readable } from 'node:stream';
import { DownloadOptions } from '../../types/network.types';
import { CryptoService } from '../crypto.service';
import { DownloadService } from './download.service';
import { RangeOptions } from '../../utils/network.utils';
import { ActionState } from '@internxt/inxt-js/build/api';
export declare class NetworkFacade {
    private readonly network;
    private readonly environment;
    private readonly downloadService;
    private readonly cryptoService;
    private readonly cryptoLib;
    constructor(network: Network.Network, environment: Environment, downloadService: DownloadService, cryptoService: CryptoService);
    downloadToStream(bucketId: string, mnemonic: string, fileId: string, size: number, to: WritableStream, rangeOptions?: RangeOptions, options?: DownloadOptions): Promise<[Promise<void>, AbortController]>;
    uploadFile(from: Readable, size: number, bucketId: string, finishedCallback: (err: Error | null, res: string | null) => void, progressCallback: (progress: number) => void): ActionState;
}
