import { StorageTypes } from '@internxt/sdk/dist/drive';
export declare class TrashService {
    static readonly instance: TrashService;
    trashItems: (payload: StorageTypes.AddItemsToTrashPayload) => Promise<void>;
    deleteFile: (fileId: string) => Promise<{
        deleted: boolean;
    }>;
    deleteFolder: (folderId: string) => Promise<void>;
    clearTrash: () => Promise<void>;
    getTrashFolderContent: () => Promise<{
        folders: {
            type: string;
            id: number;
            parentId: number;
            parentUuid: string;
            name: string;
            parent: import("@internxt/sdk/dist/schema").components["schemas"]["Folder"];
            bucket: string;
            userId: number;
            encryptVersion: string;
            createdAt: string;
            updatedAt: string;
            uuid: string;
            plainName: string;
            size: number;
            creationTime: string;
            modificationTime: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
            removed: boolean;
            deleted: boolean;
        }[];
        files: {
            id: number;
            uuid: string;
            fileId: string;
            name: string;
            type: string;
            size: string;
            bucket: string;
            folderId: number;
            folderUuid: string;
            encryptVersion: string;
            userId: number;
            creationTime: string;
            modificationTime: string;
            createdAt: string;
            updatedAt: string;
            plainName: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
        }[];
    }>;
    private readonly getAllTrashSubfolders;
    private readonly getAllTrashSubfiles;
}
