"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriveFolderService = void 0;
const sdk_manager_service_1 = require("../sdk-manager.service");
const drive_utils_1 = require("../../utils/drive.utils");
class DriveFolderService {
    static instance = new DriveFolderService();
    getFolderMetaByUuid = async (uuid) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const folderMeta = await storageClient.getFolderMeta(uuid);
        return drive_utils_1.DriveUtils.driveFolderMetaToItem(folderMeta);
    };
    getFolderMetaById = async (id) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const folderMeta = await storageClient.getFolderMetaById(id);
        return drive_utils_1.DriveUtils.driveFolderMetaToItem(folderMeta);
    };
    getFolderContent = async (folderUuid) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const folders = await this.getAllSubfolders(storageClient, folderUuid, 0);
        const files = await this.getAllSubfiles(storageClient, folderUuid, 0);
        return { folders, files };
    };
    getAllSubfolders = async (storageClient, folderUuid, offset) => {
        const [folderContentPromise] = storageClient.getFolderFoldersByUuid(folderUuid, offset, 50, 'plainName', 'ASC');
        const { folders } = await folderContentPromise;
        if (folders.length > 0) {
            return folders.concat(await this.getAllSubfolders(storageClient, folderUuid, offset + folders.length));
        }
        else {
            return folders;
        }
    };
    getAllSubfiles = async (storageClient, folderUuid, offset) => {
        const [folderContentPromise] = storageClient.getFolderFilesByUuid(folderUuid, offset, 50, 'plainName', 'ASC');
        const { files } = await folderContentPromise;
        if (files.length > 0) {
            return files.concat(await this.getAllSubfiles(storageClient, folderUuid, offset + files.length));
        }
        else {
            return files;
        }
    };
    moveFolder = (uuid, payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.moveFolderByUuid(uuid, payload);
    };
    createFolder(payload) {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.createFolderByUuid(payload);
    }
    renameFolder = (payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.updateFolderNameWithUUID(payload);
    };
    getFolderMetadataByPath = async (path) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const folderMeta = await storageClient.getFolderByPath(encodeURIComponent(path));
        return drive_utils_1.DriveUtils.driveFolderMetaToItem({
            ...folderMeta,
            createdAt: folderMeta.createdAt ?? folderMeta.created_at,
            updatedAt: folderMeta.updatedAt ?? folderMeta.updated_at,
            plainName: folderMeta.plainName ?? folderMeta.plain_name,
            parentId: folderMeta.parentId ?? folderMeta.parent_id,
            parentUuid: folderMeta.parentUuid ?? folderMeta.parent_uuid,
        });
    };
}
exports.DriveFolderService = DriveFolderService;
