import { StorageTypes } from '@internxt/sdk/dist/drive';
import { DriveFolderItem } from '../../types/drive.types';
import { RequestCanceler } from '@internxt/sdk/dist/shared/http/types';
export declare class DriveFolderService {
    static readonly instance: DriveFolderService;
    getFolderMetaByUuid: (uuid: string) => Promise<DriveFolderItem>;
    getFolderMetaById: (id: number) => Promise<DriveFolderItem>;
    getFolderContent: (folderUuid: string) => Promise<{
        folders: {
            type: string;
            id: number;
            parentId: number;
            parentUuid: string;
            name: string;
            parent: import("@internxt/sdk/dist/schema").components["schemas"]["Folder"];
            bucket: string;
            userId: number;
            encryptVersion: string;
            createdAt: string;
            updatedAt: string;
            uuid: string;
            plainName: string;
            size: number;
            creationTime: string;
            modificationTime: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
            removed: boolean;
            deleted: boolean;
        }[];
        files: {
            id: number;
            uuid: string;
            fileId: string;
            name: string;
            type: string;
            size: string;
            bucket: string;
            folderId: number;
            folderUuid: string;
            encryptVersion: string;
            userId: number;
            creationTime: string;
            modificationTime: string;
            createdAt: string;
            updatedAt: string;
            plainName: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
        }[];
    }>;
    private readonly getAllSubfolders;
    private readonly getAllSubfiles;
    moveFolder: (uuid: string, payload: StorageTypes.MoveFolderUuidPayload) => Promise<StorageTypes.FolderMeta>;
    createFolder(payload: StorageTypes.CreateFolderByUuidPayload): [Promise<StorageTypes.CreateFolderResponse>, RequestCanceler];
    renameFolder: (payload: {
        folderUuid: string;
        name: string;
    }) => Promise<void>;
    getFolderMetadataByPath: (path: string) => Promise<DriveFolderItem>;
}
