"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriveFile = void 0;
class DriveFile {
    id;
    name;
    type;
    uuid;
    fileId;
    folderId;
    folderUuid;
    bucket;
    relativePath;
    createdAt;
    updatedAt;
    size;
    status;
    creationTime;
    modificationTime;
    constructor({ id, name, type, uuid, fileId, folderId, folderUuid, bucket, relativePath, createdAt, updatedAt, size, status, creationTime, modificationTime, }) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.uuid = uuid;
        this.fileId = fileId;
        this.folderId = folderId;
        this.folderUuid = folderUuid;
        this.bucket = bucket;
        this.relativePath = relativePath;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.size = size;
        this.status = status;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
    }
    static build(file) {
        return new DriveFile(file);
    }
    toJSON() {
        return {
            id: this.id,
            name: this.name,
            type: this.type,
            uuid: this.uuid,
            fileId: this.fileId,
            folderId: this.folderId,
            folderUuid: this.folderUuid,
            bucket: this.bucket,
            relativePath: this.relativePath,
            createdAt: this.createdAt,
            updatedAt: this.updatedAt,
            size: this.size,
            status: this.status,
            creationTime: this.creationTime,
            modificationTime: this.modificationTime,
        };
    }
    toItem() {
        return {
            itemType: 'file',
            id: this.id,
            name: this.name,
            type: this.type,
            uuid: this.uuid,
            fileId: this.fileId,
            folderId: this.folderId,
            folderUuid: this.folderUuid,
            bucket: this.bucket,
            createdAt: this.createdAt,
            updatedAt: this.updatedAt,
            size: this.size,
            status: this.status,
            creationTime: this.creationTime,
            modificationTime: this.modificationTime,
        };
    }
}
exports.DriveFile = DriveFile;
