import { DriveFileItem } from '../../../types/drive.types';
import { DriveFileAttributes } from './drive-file.attributes';
export declare class DriveFile implements DriveFileAttributes {
    id: number;
    name: string;
    type?: string;
    uuid: string;
    fileId: string;
    folderId: number;
    folderUuid: string;
    bucket: string;
    relativePath: string;
    createdAt: Date;
    updatedAt: Date;
    size: number;
    status: 'EXISTS' | 'TRASHED' | 'DELETED';
    creationTime: Date;
    modificationTime: Date;
    constructor({ id, name, type, uuid, fileId, folderId, folderUuid, bucket, relativePath, createdAt, updatedAt, size, status, creationTime, modificationTime, }: DriveFileAttributes);
    static build(file: DriveFileAttributes): DriveFile;
    toJSON(): DriveFileAttributes;
    toItem(): DriveFileItem;
}
